/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.Random;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.LightningStrikeEvent;

public class OnLightningStrike
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;

    public OnLightningStrike(IBloodmoonService iBloodmoonService, IConfigService iConfigService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
    }

    @EventHandler
    public void onLightningStrike(LightningStrikeEvent lightningStrikeEvent) {
        World world = lightningStrikeEvent.getWorld();
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        if (lightningStrikeEvent.getCause() != LightningStrikeEvent.Cause.WEATHER) {
            return;
        }
        Random random = new Random();
        double d = random.nextDouble() * 100.0;
        if (d < this.configService.getLightningStrikeChance()) {
            lightningStrikeEvent.setCancelled(true);
            Player player = (Player)world.getPlayers().get(new Random().nextInt(world.getPlayers().size()));
            Location location = player.getLocation();
            Location location2 = new Location(player.getWorld(), location.getX(), (double)world.getHighestBlockYAt(location), location.getZ());
            return;
        }
        Random random2 = new Random();
        double d2 = random2.nextDouble() * 100.0;
        if (d2 <= this.configService.getLightningStrikeChance()) {
            lightningStrikeEvent.setCancelled(true);
            Player player = (Player)world.getPlayers().get(new Random().nextInt(world.getPlayers().size()));
            Location location = player.getLocation();
            Location location3 = new Location(player.getWorld(), location.getX(), (double)world.getHighestBlockYAt(location), location.getZ() + 2.0);
            world.strikeLightning(location3);
            return;
        }
    }
}

