/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import me.mrgeneralq.bloodmoon.BloodmoonCore;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.interfaces.services.IResourcePackService;
import me.mrgeneralq.bloodmoon.interfaces.services.IUpdateService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class OnPlayerJoin
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;
    private final IMessageService messageService;
    private final IUpdateService updateService;
    private final IResourcePackService resourcePackService;
    private final IBloodmoonScheduleService scheduleService;
    private final BloodmoonCore bloodmoonCore;

    public OnPlayerJoin(IBloodmoonService iBloodmoonService, IConfigService iConfigService, IMessageService iMessageService, IUpdateService iUpdateService, IResourcePackService iResourcePackService, IBloodmoonScheduleService iBloodmoonScheduleService, BloodmoonCore bloodmoonCore) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
        this.messageService = iMessageService;
        this.updateService = iUpdateService;
        this.resourcePackService = iResourcePackService;
        this.scheduleService = iBloodmoonScheduleService;
        this.bloodmoonCore = bloodmoonCore;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        Object object;
        Object object2;
        final Player player = playerJoinEvent.getPlayer();
        World world = player.getWorld();
        Bloodmoon bloodmoon = this.bloodmoonService.getBloodmoon(world);
        bloodmoon.getBossbar().addPlayer(player);
        if (player.hasPermission("bloodmoon.version") && !this.configService.getCurrentVersion().equalsIgnoreCase(this.configService.getConfigVersion())) {
            player.sendMessage(Message.getMessage(this.messageService.getMessage("prefix", false) + " &cConfig is not up-to-date! Please update the config!"));
        }
        if (player.hasPermission("bloodmoon.notify") && this.configService.isUpdateCheckerEnabled()) {
            object2 = () -> {
                boolean bl = this.updateService.hasUpdate();
                if (bl) {
                    String string = String.format(this.messageService.getMessage("prefix", false) + "&a A newer update is available. You are currently using %s and the latest version is %s", this.updateService.getCurrentVersion(), this.updateService.getCachedUpdateVersion());
                    player.sendMessage(Message.getMessage(string));
                }
            };
            object = new Thread((Runnable)object2);
            ((Thread)object).start();
        }
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            if (!this.scheduleService.isScheduled(world)) {
                return;
            }
            if (player.hasPermission("bloodmoon.schedule")) {
                object2 = this.scheduleService.getSchedule(world);
                if (((BloodmoonSchedule)object2).isToday()) {
                    if (((BloodmoonSchedule)object2).isBroadcasting()) {
                        player.sendMessage(this.messageService.getMessageHelper(((BloodmoonSchedule)object2).getTonightMessage()).usePrefix().setSchedule((BloodmoonSchedule)object2).getMessage());
                    }
                    return;
                }
                if (((BloodmoonSchedule)object2).isBroadcasting()) {
                    player.sendMessage(this.messageService.getMessageHelper(((BloodmoonSchedule)object2).getDaysLeftMessage()).usePrefix().setSchedule((BloodmoonSchedule)object2).getMessage());
                }
            }
            return;
        }
        if (this.configService.startTitleEnabled()) {
            object2 = this.configService.getStartTitle();
            object = this.configService.getStartSubTitle();
            player.sendTitle(Message.getMessage((String)object2), (String)object, 10, 70, 20);
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.bloodmoonCore, new Runnable(){

            @Override
            public void run() {
                if (OnPlayerJoin.this.configService.isSetResourcePack()) {
                    OnPlayerJoin.this.resourcePackService.setResourcePackEnabled(player, true);
                }
            }
        }, 20L);
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        Bloodmoon bloodmoon = this.bloodmoonService.getBloodmoon(player.getWorld());
        bloodmoon.getBossbar().removePlayer(player);
    }
}

