/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPortalEvent;

public class OnPlayerPortal
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;
    private final IMessageService messageService;

    public OnPlayerPortal(IBloodmoonService iBloodmoonService, IConfigService iConfigService, IMessageService iMessageService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
        this.messageService = iMessageService;
    }

    @EventHandler
    public void onPlayerPortal(PlayerPortalEvent playerPortalEvent) {
        Player player = playerPortalEvent.getPlayer();
        World world = player.getWorld();
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        if (!this.configService.isPortalDisabled()) {
            return;
        }
        if (player.hasPermission("bloodmoon.bypass.use-portals")) {
            return;
        }
        playerPortalEvent.setCancelled(true);
        player.sendMessage(this.messageService.getMessage(Message.portal, true));
    }
}

