/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.SignUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class OnSignBreak
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;

    public OnSignBreak(IBloodmoonService iBloodmoonService, IMessageService iMessageService) {
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
    }

    @EventHandler
    public void onSignBreak(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Block block = blockBreakEvent.getBlock();
        Player player = blockBreakEvent.getPlayer();
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        List list = Arrays.stream(sign.getLines()).filter(string -> string.length() != 0).collect(Collectors.toList());
        if (!SignUtils.isBloodmoonSign(sign)) {
            return;
        }
        String string2 = (String)list.get(1);
        String string3 = String.format("bloodmoon.sign.destroy.%s", string2);
        if (!player.hasPermission(string3)) {
            player.sendMessage(this.messageService.getMessage("sign-destroy-no-permission", true));
            blockBreakEvent.setCancelled(true);
            return;
        }
        player.sendMessage(this.messageService.getMessage("sign-destroyed", true));
    }
}

