/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.statics;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bukkit.Bukkit;

public enum ServerVersion {
    UNKNOWN,
    V1_8,
    V1_9,
    V1_10,
    V1_11,
    V1_12,
    V1_13,
    V1_14,
    V1_15,
    V1_16,
    V1_17,
    V1_18,
    V1_19;

    private final String name = this.name().substring(1).replace('_', '.').toUpperCase();
    private boolean supportsHexColors;
    private boolean supportsTitles;
    private boolean sleepCalculatedDifferently;
    public static final ServerVersion CURRENT_VERSION;
    public static final String UPDATE_URL = "https://www.spigotmc.org/resources/75095/";
    private static final ServerVersion[] VALUES;

    public String getName() {
        return this.name;
    }

    public boolean supportsHexColors() {
        return this.supportsHexColors;
    }

    public boolean supportsTitles() {
        return this.supportsTitles;
    }

    public boolean sleepCalculatedDifferently() {
        return this.sleepCalculatedDifferently;
    }

    private static ServerVersion computeServerVersion() {
        return Arrays.stream(VALUES).filter(serverVersion -> Bukkit.getVersion().contains(serverVersion.getName())).findFirst().orElse(UNKNOWN);
    }

    private static void forVersionsFrom(ServerVersion serverVersion, Consumer<ServerVersion> consumer) {
        ServerVersion.versionsStream().filter(serverVersion2 -> serverVersion2.ordinal() >= serverVersion.ordinal()).forEach(consumer);
    }

    private static void forVersionsUntil(ServerVersion serverVersion, Consumer<ServerVersion> consumer) {
        ServerVersion.versionsStream().filter(serverVersion2 -> serverVersion2.ordinal() <= serverVersion.ordinal()).forEach(consumer);
    }

    private static Stream<ServerVersion> versionsStream() {
        return Arrays.stream(VALUES).filter(serverVersion -> serverVersion != UNKNOWN);
    }

    static {
        VALUES = ServerVersion.values();
        CURRENT_VERSION = ServerVersion.computeServerVersion();
        ServerVersion.forVersionsFrom(V1_16, serverVersion -> {
            serverVersion.supportsHexColors = true;
            serverVersion.supportsTitles = true;
        });
        ServerVersion.forVersionsUntil(V1_14, serverVersion -> {
            serverVersion.sleepCalculatedDifferently = true;
        });
    }
}

