/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.apache.commons.lang3;

import me.forseth11.easybackup.dependencies.apache.commons.lang3.StringUtils;
import me.forseth11.easybackup.dependencies.apache.commons.lang3.Validate;

public class CharUtils {
    private static final String[] CHAR_STRING_ARRAY = new String[128];
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char NUL = '\u0000';

    @Deprecated
    public static Character toCharacterObject(char c10) {
        return Character.valueOf(c10);
    }

    public static Character toCharacterObject(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return Character.valueOf(string.charAt(0));
    }

    public static char toChar(Character c10) {
        Validate.notNull(c10, "The Character must not be null", new Object[0]);
        return c10.charValue();
    }

    public static char toChar(Character c10, char c11) {
        if (c10 == null) {
            return c11;
        }
        return c10.charValue();
    }

    public static char toChar(String string) {
        Validate.notEmpty(string, "The String must not be empty", new Object[0]);
        return string.charAt(0);
    }

    public static char toChar(String string, char c10) {
        if (StringUtils.isEmpty(string)) {
            return c10;
        }
        return string.charAt(0);
    }

    public static int toIntValue(char c10) {
        if (!CharUtils.isAsciiNumeric(c10)) {
            throw new IllegalArgumentException("The character " + c10 + " is not in the range '0' - '9'");
        }
        return c10 - 48;
    }

    public static int toIntValue(char c10, int n2) {
        if (!CharUtils.isAsciiNumeric(c10)) {
            return n2;
        }
        return c10 - 48;
    }

    public static int toIntValue(Character c10) {
        Validate.notNull(c10, "The character must not be null", new Object[0]);
        return CharUtils.toIntValue(c10.charValue());
    }

    public static int toIntValue(Character c10, int n2) {
        if (c10 == null) {
            return n2;
        }
        return CharUtils.toIntValue(c10.charValue(), n2);
    }

    public static String toString(char c10) {
        if (c10 < '\u0080') {
            return CHAR_STRING_ARRAY[c10];
        }
        return new String(new char[]{c10});
    }

    public static String toString(Character c10) {
        if (c10 == null) {
            return null;
        }
        return CharUtils.toString(c10.charValue());
    }

    public static String unicodeEscaped(char c10) {
        return "\\u" + HEX_DIGITS[c10 >> 12 & 0xF] + HEX_DIGITS[c10 >> 8 & 0xF] + HEX_DIGITS[c10 >> 4 & 0xF] + HEX_DIGITS[c10 & 0xF];
    }

    public static String unicodeEscaped(Character c10) {
        if (c10 == null) {
            return null;
        }
        return CharUtils.unicodeEscaped(c10.charValue());
    }

    public static boolean isAscii(char c10) {
        return c10 < '\u0080';
    }

    public static boolean isAsciiPrintable(char c10) {
        return c10 >= ' ' && c10 < '\u007f';
    }

    public static boolean isAsciiControl(char c10) {
        return c10 < ' ' || c10 == '\u007f';
    }

    public static boolean isAsciiAlpha(char c10) {
        return CharUtils.isAsciiAlphaUpper(c10) || CharUtils.isAsciiAlphaLower(c10);
    }

    public static boolean isAsciiAlphaUpper(char c10) {
        return c10 >= 'A' && c10 <= 'Z';
    }

    public static boolean isAsciiAlphaLower(char c10) {
        return c10 >= 'a' && c10 <= 'z';
    }

    public static boolean isAsciiNumeric(char c10) {
        return c10 >= '0' && c10 <= '9';
    }

    public static boolean isAsciiAlphanumeric(char c10) {
        return CharUtils.isAsciiAlpha(c10) || CharUtils.isAsciiNumeric(c10);
    }

    public static int compare(char c10, char c11) {
        return c10 - c11;
    }

    static {
        for (char c10 = '\u0000'; c10 < CHAR_STRING_ARRAY.length; c10 = (char)(c10 + '\u0001')) {
            CharUtils.CHAR_STRING_ARRAY[c10] = String.valueOf(c10);
        }
    }
}

