/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.apache.commons.net.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.CopyStreamException;
import me.forseth11.easybackup.dependencies.apache.commons.net.io.CopyStreamListener;

public final class Util {
    public static final int DEFAULT_COPY_BUFFER_SIZE = 1024;

    private Util() {
    }

    public static final long copyStream(InputStream inputStream, OutputStream outputStream, int n2, long l2, CopyStreamListener copyStreamListener, boolean bl2) {
        long l3 = 0L;
        byte[] byArray = new byte[n2 >= 0 ? n2 : 1024];
        try {
            int n3;
            while ((n3 = inputStream.read(byArray)) != -1) {
                if (n3 == 0) {
                    n3 = inputStream.read();
                    if (n3 >= 0) {
                        outputStream.write(n3);
                        if (bl2) {
                            outputStream.flush();
                        }
                        ++l3;
                        if (copyStreamListener == null) continue;
                        copyStreamListener.bytesTransferred(l3, 1, l2);
                        continue;
                    }
                    break;
                }
                outputStream.write(byArray, 0, n3);
                if (bl2) {
                    outputStream.flush();
                }
                l3 += (long)n3;
                if (copyStreamListener == null) continue;
                copyStreamListener.bytesTransferred(l3, n3, l2);
            }
        }
        catch (IOException iOException) {
            throw new CopyStreamException("IOException caught while copying.", l3, iOException);
        }
        return l3;
    }

    public static final long copyStream(InputStream inputStream, OutputStream outputStream, int n2, long l2, CopyStreamListener copyStreamListener) {
        return Util.copyStream(inputStream, outputStream, n2, l2, copyStreamListener, true);
    }

    public static final long copyStream(InputStream inputStream, OutputStream outputStream, int n2) {
        return Util.copyStream(inputStream, outputStream, n2, -1L, null);
    }

    public static final long copyStream(InputStream inputStream, OutputStream outputStream) {
        return Util.copyStream(inputStream, outputStream, 1024);
    }

    public static final long copyReader(Reader reader, Writer writer, int n2, long l2, CopyStreamListener copyStreamListener) {
        long l3 = 0L;
        char[] cArray = new char[n2 >= 0 ? n2 : 1024];
        try {
            int n3;
            while ((n3 = reader.read(cArray)) != -1) {
                if (n3 == 0) {
                    n3 = reader.read();
                    if (n3 >= 0) {
                        writer.write(n3);
                        writer.flush();
                        ++l3;
                        if (copyStreamListener == null) continue;
                        copyStreamListener.bytesTransferred(l3, n3, l2);
                        continue;
                    }
                    break;
                }
                writer.write(cArray, 0, n3);
                writer.flush();
                l3 += (long)n3;
                if (copyStreamListener == null) continue;
                copyStreamListener.bytesTransferred(l3, n3, l2);
            }
        }
        catch (IOException iOException) {
            throw new CopyStreamException("IOException caught while copying.", l3, iOException);
        }
        return l3;
    }

    public static final long copyReader(Reader reader, Writer writer, int n2) {
        return Util.copyReader(reader, writer, n2, -1L, null);
    }

    public static final long copyReader(Reader reader, Writer writer) {
        return Util.copyReader(reader, writer, 1024);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

