/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraints;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialChar;
import me.forseth11.easybackup.dependencies.cronutils.utils.VisibleForTesting;

public class StringValidations {
    private static final String ESCAPED_END = ")\\b";
    private static final String ESCAPED_START = "\\b(";
    private static final SpecialChar[] SPECIAL_CHARS = new SpecialChar[]{SpecialChar.L, SpecialChar.LW, SpecialChar.W};
    private static final Pattern NUMS_AND_CHARS_PATTERN = Pattern.compile("[#\\?/\\*0-9]");
    private final Pattern stringToIntKeysPattern;
    private final Pattern lwPattern;

    public StringValidations(FieldConstraints fieldConstraints) {
        this.lwPattern = this.buildLWPattern(fieldConstraints.getSpecialChars());
        this.stringToIntKeysPattern = this.buildStringToIntPattern(fieldConstraints.getStringMappingKeySet());
    }

    @VisibleForTesting
    Pattern buildStringToIntPattern(Set<String> set) {
        return this.buildWordsPattern(set);
    }

    @VisibleForTesting
    public String removeValidChars(String string) {
        Matcher matcher = NUMS_AND_CHARS_PATTERN.matcher(string.toUpperCase());
        Matcher matcher2 = this.stringToIntKeysPattern.matcher(matcher.replaceAll(""));
        Matcher matcher3 = this.lwPattern.matcher(matcher2.replaceAll(""));
        return matcher3.replaceAll("").replaceAll("\\s+", "").replaceAll(",", "").replaceAll("-", "");
    }

    @VisibleForTesting
    Pattern buildLWPattern(Set<SpecialChar> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (SpecialChar specialChar : SPECIAL_CHARS) {
            if (!set.contains((Object)specialChar)) continue;
            hashSet.add(specialChar.name());
        }
        return this.buildWordsPattern(hashSet);
    }

    @VisibleForTesting
    Pattern buildWordsPattern(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder(ESCAPED_START);
        Iterator<String> iterator = set.iterator();
        if (!iterator.hasNext()) {
            stringBuilder.append(ESCAPED_END);
            return Pattern.compile(stringBuilder.toString());
        }
        String string = iterator.next();
        stringBuilder.append(string);
        while (iterator.hasNext()) {
            stringBuilder.append("|");
            stringBuilder.append(iterator.next());
        }
        stringBuilder.append(ESCAPED_END);
        return Pattern.compile(stringBuilder.toString());
    }
}

