/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.descriptor;

import java.util.Locale;
import java.util.Map;
import me.forseth11.easybackup.dependencies.cronutils.descriptor.DescriptionStrategyFactory;
import me.forseth11.easybackup.dependencies.cronutils.model.Cron;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldDefinition;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class CronDescriptor {
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    private static final String BUNDLE = "CronUtilsI18N";

    public static CronDescriptor instance() {
        return new CronDescriptor();
    }

    public String describe(Cron cron) {
        Preconditions.checkNotNull(cron, "Cron must not be null");
        Map<CronFieldName, CronField> map = cron.retrieveFieldsAsMap();
        Map<CronFieldName, FieldDefinition> map2 = cron.getCronDefinition().retrieveFieldDefinitionsAsMap();
        return (this.describeHHmmss(map) + " " + this.describeDayOfMonth(map) + " " + this.describeMonth(map) + " " + this.describeDayOfWeek(map, map2) + " " + this.describeYear(map)).replaceAll("\\s+", " ").trim();
    }

    public String describeHHmmss(Map<CronFieldName, CronField> map) {
        return DescriptionStrategyFactory.hhMMssInstance(map.containsKey((Object)CronFieldName.HOUR) ? map.get((Object)CronFieldName.HOUR).getExpression() : null, map.containsKey((Object)CronFieldName.MINUTE) ? map.get((Object)CronFieldName.MINUTE).getExpression() : null, map.containsKey((Object)CronFieldName.SECOND) ? map.get((Object)CronFieldName.SECOND).getExpression() : null).describe();
    }

    public String describeDayOfMonth(Map<CronFieldName, CronField> map) {
        String string = DescriptionStrategyFactory.daysOfMonthInstance(map.containsKey((Object)CronFieldName.DAY_OF_MONTH) ? map.get((Object)CronFieldName.DAY_OF_MONTH).getExpression() : null).describe();
        return this.addTimeExpressions(string, "day", "days");
    }

    public String describeMonth(Map<CronFieldName, CronField> map) {
        String string = DescriptionStrategyFactory.monthsInstance(map.containsKey((Object)CronFieldName.MONTH) ? map.get((Object)CronFieldName.MONTH).getExpression() : null).describe();
        return this.addTimeExpressions(string, "month", "months");
    }

    private String addTimeExpressions(String string, String string2, String string3) {
        return string.replaceAll("%s", string2).replaceAll("replace_plural", string3);
    }

    public String describeDayOfWeek(Map<CronFieldName, CronField> map, Map<CronFieldName, FieldDefinition> map2) {
        String string = DescriptionStrategyFactory.daysOfWeekInstance(map.containsKey((Object)CronFieldName.DAY_OF_WEEK) ? map.get((Object)CronFieldName.DAY_OF_WEEK).getExpression() : null, map2.getOrDefault((Object)CronFieldName.DAY_OF_WEEK, null)).describe();
        return this.addExpressions(string, "day", "days");
    }

    private String addExpressions(String string, String string2, String string3) {
        return string.replaceAll("%s", string2).replaceAll("replace_plural", string3);
    }

    public String describeYear(Map<CronFieldName, CronField> map) {
        String string = DescriptionStrategyFactory.plainInstance(map.containsKey((Object)CronFieldName.YEAR) ? map.get((Object)CronFieldName.YEAR).getExpression() : null).describe();
        return this.addExpressions(string, "year", "years");
    }
}

