/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.descriptor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import me.forseth11.easybackup.dependencies.cronutils.Function;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Always;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.And;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Between;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.FieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.IntegerFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

abstract class DescriptionStrategy {
    private static final String WHITE_SPACE = " ";
    protected Function<Integer, String> nominalValueFunction = n2 -> WHITE_SPACE + n2;

    public abstract String describe();

    protected String describe(FieldExpression fieldExpression) {
        return this.describe(fieldExpression, false);
    }

    protected String describe(FieldExpression fieldExpression, boolean bl2) {
        Preconditions.checkNotNull(fieldExpression, "CronFieldExpression should not be null!");
        if (fieldExpression instanceof Always) {
            return this.describe((Always)fieldExpression, bl2);
        }
        if (fieldExpression instanceof And) {
            return this.describe((And)fieldExpression);
        }
        if (fieldExpression instanceof Between) {
            return this.describe((Between)fieldExpression, bl2);
        }
        if (fieldExpression instanceof Every) {
            return this.describe((Every)fieldExpression, bl2);
        }
        if (fieldExpression instanceof On) {
            return this.describe((On)fieldExpression, bl2);
        }
        return "";
    }

    protected String describe(Always always, boolean bl2) {
        return "";
    }

    protected String describe(And and) {
        ArrayList<FieldExpression> arrayList = new ArrayList<FieldExpression>();
        ArrayList<FieldExpression> arrayList2 = new ArrayList<FieldExpression>();
        for (FieldExpression fieldExpression : and.getExpressions()) {
            if (fieldExpression instanceof On) {
                arrayList2.add(fieldExpression);
                continue;
            }
            arrayList.add(fieldExpression);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!arrayList2.isEmpty()) {
            stringBuilder.append("at");
            this.createAndDescription(stringBuilder, arrayList2).append(" replace_plural");
        }
        if (!arrayList.isEmpty()) {
            this.createAndDescription(stringBuilder, arrayList);
        }
        return stringBuilder.toString();
    }

    protected String describe(Between between, boolean bl2) {
        return "every %s " + MessageFormat.format("between {0} and {1}", this.nominalValue(between.getFrom()), this.nominalValue(between.getTo())) + WHITE_SPACE;
    }

    protected String describe(Every every, boolean bl2) {
        String string = every.getPeriod().getValue() > 1 ? String.format("%s %s ", "every", this.nominalValue(every.getPeriod())) + " replace_plural " : "every %s ";
        if (every.getExpression() instanceof Between) {
            Between between = (Between)every.getExpression();
            string = string + MessageFormat.format("between {0} and {1}", this.nominalValue(between.getFrom()), this.nominalValue(between.getTo())) + WHITE_SPACE;
        }
        return string;
    }

    protected String describe(On on, boolean bl2) {
        if (bl2) {
            return this.nominalValue(on.getTime());
        }
        return String.format("%s %s ", "at", this.nominalValue(on.getTime())) + "%s";
    }

    protected String nominalValue(FieldValue<?> fieldValue) {
        Preconditions.checkNotNull(fieldValue, "FieldValue must not be null");
        if (fieldValue instanceof IntegerFieldValue) {
            return this.nominalValueFunction.apply(((IntegerFieldValue)fieldValue).getValue());
        }
        return fieldValue.toString();
    }

    private StringBuilder createAndDescription(StringBuilder stringBuilder, List<FieldExpression> list) {
        if (list.size() - 2 >= 0) {
            for (int i2 = 0; i2 < list.size() - 2; ++i2) {
                stringBuilder.append(String.format(" %s, ", this.describe(list.get(i2), true)));
            }
            stringBuilder.append(String.format(" %s ", this.describe(list.get(list.size() - 2), true)));
        }
        stringBuilder.append(String.format(" %s ", "and"));
        stringBuilder.append(this.describe(list.get(list.size() - 1), true));
        return stringBuilder;
    }
}

