/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.descriptor.refactor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Always;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.And;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Between;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.QuestionMark;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.visitor.FieldExpressionVisitor;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.FieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.IntegerFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;
import me.forseth11.easybackup.dependencies.cronutils.utils.VisibleForTesting;

class SecondsDescriptor
implements FieldExpressionVisitor {
    private static final String EVERY = "every";
    protected ResourceBundle bundle;

    SecondsDescriptor(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public String describe(FieldExpression fieldExpression) {
        return this.describe(fieldExpression, false);
    }

    protected String describe(FieldExpression fieldExpression, boolean bl2) {
        Preconditions.checkNotNull(fieldExpression, "CronFieldExpression should not be null!");
        if (fieldExpression instanceof Always) {
            return this.describe(fieldExpression, bl2);
        }
        if (fieldExpression instanceof And) {
            return this.describe((And)fieldExpression);
        }
        if (fieldExpression instanceof Between) {
            return this.describe(fieldExpression, bl2);
        }
        if (fieldExpression instanceof Every) {
            return this.describe((Every)fieldExpression, bl2);
        }
        if (fieldExpression instanceof On) {
            return this.describe((On)fieldExpression, bl2);
        }
        return "";
    }

    protected String describe(Always always, boolean bl2) {
        return this.bundle.getString(EVERY);
    }

    protected String describe(And and) {
        ArrayList<FieldExpression> arrayList = new ArrayList<FieldExpression>();
        ArrayList<FieldExpression> arrayList2 = new ArrayList<FieldExpression>();
        for (FieldExpression fieldExpression : and.getExpressions()) {
            if (fieldExpression instanceof On) {
                arrayList2.add(fieldExpression);
                continue;
            }
            arrayList.add(fieldExpression);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!arrayList2.isEmpty()) {
            stringBuilder.append(this.bundle.getString("at"));
            this.createAndDescription(stringBuilder, arrayList2);
        }
        if (!arrayList.isEmpty()) {
            this.createAndDescription(stringBuilder, arrayList);
        }
        return stringBuilder.toString();
    }

    protected String describe(Between between, boolean bl2) {
        return MessageFormat.format(this.bundle.getString("between_x_and_y"), this.nominalValue(between.getFrom()), this.nominalValue(between.getTo())) + " ";
    }

    protected String describe(Every every, boolean bl2) {
        return null;
    }

    protected String describe(On on, boolean bl2) {
        if (bl2) {
            return this.nominalValue(on.getTime());
        }
        return String.format("%s %s ", this.bundle.getString("at"), this.nominalValue(on.getTime())) + "%s";
    }

    protected String nominalValue(FieldValue<?> fieldValue) {
        Preconditions.checkNotNull(fieldValue, "FieldValue must not be null");
        if (fieldValue instanceof IntegerFieldValue) {
            return "" + ((IntegerFieldValue)fieldValue).getValue();
        }
        return fieldValue.toString();
    }

    @VisibleForTesting
    StringBuilder createAndDescription(StringBuilder stringBuilder, List<FieldExpression> list) {
        if (list.size() - 2 >= 0) {
            for (int i2 = 0; i2 < list.size() - 2; ++i2) {
                stringBuilder.append(String.format(" %s, ", this.describe(list.get(i2), true)));
            }
            stringBuilder.append(String.format(" %s ", this.describe(list.get(list.size() - 2), true)));
        }
        stringBuilder.append(String.format(" %s ", this.bundle.getString("and")));
        stringBuilder.append(this.describe(list.get(list.size() - 1), true));
        return stringBuilder;
    }

    @Override
    public FieldExpression visit(FieldExpression fieldExpression) {
        return null;
    }

    @Override
    public Always visit(Always always) {
        return null;
    }

    @Override
    public And visit(And and) {
        return null;
    }

    @Override
    public Between visit(Between between) {
        return null;
    }

    @Override
    public Every visit(Every every) {
        if (every.getPeriod().getValue() > 1) {
            String string = String.format("%s %s ", this.bundle.getString(EVERY), this.nominalValue(every.getPeriod())) + " replace_plural ";
        } else {
            String string = this.bundle.getString(EVERY) + " %s ";
        }
        return every;
    }

    @Override
    public On visit(On on) {
        return null;
    }

    @Override
    public QuestionMark visit(QuestionMark questionMark) {
        return null;
    }
}

