/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.mapper;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import me.forseth11.easybackup.dependencies.cronutils.Function;
import me.forseth11.easybackup.dependencies.cronutils.mapper.ConstantsMapper;
import me.forseth11.easybackup.dependencies.cronutils.model.Cron;
import me.forseth11.easybackup.dependencies.cronutils.model.CronType;
import me.forseth11.easybackup.dependencies.cronutils.model.SingleCron;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.definition.CronDefinitionBuilder;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraints;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraintsBuilder;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Always;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.QuestionMark;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.visitor.ValueMappingFieldExpressionVisitor;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.IntegerFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialChar;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;
import me.forseth11.easybackup.dependencies.cronutils.utils.VisibleForTesting;

public class CronMapper {
    private final Map<CronFieldName, Function<CronField, CronField>> mappings;
    private final Function<Cron, Cron> cronRules;
    private final CronDefinition to;

    public CronMapper(CronDefinition cronDefinition, CronDefinition cronDefinition2, Function<Cron, Cron> function) {
        Preconditions.checkNotNull(cronDefinition, "Source CronDefinition must not be null");
        this.to = Preconditions.checkNotNull(cronDefinition2, "Destination CronDefinition must not be null");
        this.cronRules = Preconditions.checkNotNull(function, "CronRules must not be null");
        this.mappings = new EnumMap<CronFieldName, Function<CronField, CronField>>(CronFieldName.class);
        this.buildMappings(cronDefinition, cronDefinition2);
    }

    public static CronMapper fromCron4jToQuartz() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.CRON4J), CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronMapper.setQuestionMark());
    }

    public static CronMapper fromQuartzToCron4j() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronDefinitionBuilder.instanceDefinitionFor(CronType.CRON4J), CronMapper.sameCron());
    }

    public static CronMapper fromQuartzToUnix() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX), CronMapper.sameCron());
    }

    public static CronMapper fromUnixToQuartz() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX), CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronMapper.setQuestionMark());
    }

    public static CronMapper fromQuartzToSpring() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronDefinitionBuilder.instanceDefinitionFor(CronType.SPRING), CronMapper.setQuestionMark());
    }

    public static CronMapper sameCron(CronDefinition cronDefinition) {
        return new CronMapper(cronDefinition, cronDefinition, CronMapper.sameCron());
    }

    private static Function<Cron, Cron> sameCron() {
        return cron -> cron;
    }

    private static Function<Cron, Cron> setQuestionMark() {
        return cron -> {
            CronField cronField = cron.retrieve(CronFieldName.DAY_OF_WEEK);
            CronField cronField2 = cron.retrieve(CronFieldName.DAY_OF_MONTH);
            if (cronField == null && cronField2 == null) {
                return cron;
            }
            if (cronField.getExpression() instanceof QuestionMark || cronField2.getExpression() instanceof QuestionMark) {
                return cron;
            }
            EnumMap<CronFieldName, CronField> enumMap = new EnumMap<CronFieldName, CronField>(CronFieldName.class);
            enumMap.putAll(cron.retrieveFieldsAsMap());
            if (cronField.getExpression() instanceof Always) {
                enumMap.put(CronFieldName.DAY_OF_WEEK, new CronField(CronFieldName.DAY_OF_WEEK, FieldExpression.questionMark(), ((CronField)enumMap.get((Object)CronFieldName.DAY_OF_WEEK)).getConstraints()));
            } else if (cronField2.getExpression() instanceof Always) {
                enumMap.put(CronFieldName.DAY_OF_MONTH, new CronField(CronFieldName.DAY_OF_MONTH, FieldExpression.questionMark(), ((CronField)enumMap.get((Object)CronFieldName.DAY_OF_MONTH)).getConstraints()));
            } else {
                cron.validate();
            }
            return new SingleCron(cron.getCronDefinition(), new ArrayList<CronField>(enumMap.values()));
        };
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnSameExpression() {
        return cronField -> cronField;
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnOnZeroExpression(CronFieldName cronFieldName) {
        return cronField -> {
            FieldConstraints fieldConstraints = FieldConstraintsBuilder.instance().forField(cronFieldName).createConstraintsInstance();
            return new CronField(cronFieldName, new On(new IntegerFieldValue(0)), fieldConstraints);
        };
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnAlwaysExpression(CronFieldName cronFieldName) {
        return cronField -> new CronField(cronFieldName, FieldExpression.always(), FieldConstraintsBuilder.instance().forField(cronFieldName).createConstraintsInstance());
    }

    @VisibleForTesting
    static Function<CronField, CronField> dayOfWeekMapping(DayOfWeekFieldDefinition dayOfWeekFieldDefinition, DayOfWeekFieldDefinition dayOfWeekFieldDefinition2) {
        return cronField -> {
            FieldExpression fieldExpression = cronField.getExpression();
            FieldExpression fieldExpression2 = null;
            fieldExpression2 = fieldExpression.accept(new ValueMappingFieldExpressionVisitor(fieldValue -> {
                if (fieldValue instanceof IntegerFieldValue) {
                    return new IntegerFieldValue(ConstantsMapper.weekDayMapping(dayOfWeekFieldDefinition.getMondayDoWValue(), dayOfWeekFieldDefinition2.getMondayDoWValue(), ((IntegerFieldValue)fieldValue).getValue()));
                }
                return fieldValue;
            }));
            if (fieldExpression instanceof QuestionMark && !dayOfWeekFieldDefinition2.getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
                fieldExpression2 = FieldExpression.always();
            }
            return new CronField(CronFieldName.DAY_OF_WEEK, fieldExpression2, dayOfWeekFieldDefinition2.getConstraints());
        };
    }

    @VisibleForTesting
    static Function<CronField, CronField> dayOfMonthMapping(FieldDefinition fieldDefinition, FieldDefinition fieldDefinition2) {
        return cronField -> {
            FieldExpression fieldExpression;
            FieldExpression fieldExpression2 = fieldExpression = cronField.getExpression();
            if (fieldExpression instanceof QuestionMark && !fieldDefinition2.getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
                fieldExpression2 = FieldExpression.always();
            }
            return new CronField(CronFieldName.DAY_OF_MONTH, fieldExpression2, fieldDefinition2.getConstraints());
        };
    }

    public Cron map(Cron cron) {
        Preconditions.checkNotNull(cron, "Cron must not be null");
        ArrayList<CronField> arrayList = new ArrayList<CronField>();
        for (CronFieldName cronFieldName : CronFieldName.values()) {
            CronField cronField;
            if (!this.mappings.containsKey((Object)cronFieldName) || (cronField = this.mappings.get((Object)cronFieldName).apply(cron.retrieve(cronFieldName))) == null) continue;
            arrayList.add(cronField);
        }
        return this.cronRules.apply(new SingleCron(this.to, arrayList)).validate();
    }

    private void buildMappings(CronDefinition cronDefinition, CronDefinition cronDefinition2) {
        Map<CronFieldName, FieldDefinition> map = this.getFieldDefinitions(cronDefinition);
        Map<CronFieldName, FieldDefinition> map2 = this.getFieldDefinitions(cronDefinition2);
        boolean bl2 = false;
        boolean bl3 = false;
        for (CronFieldName cronFieldName : CronFieldName.values()) {
            FieldDefinition fieldDefinition = map2.get((Object)cronFieldName);
            FieldDefinition fieldDefinition2 = map.get((Object)cronFieldName);
            if (fieldDefinition != null) {
                bl2 = true;
            }
            if (fieldDefinition2 != null) {
                bl3 = true;
            }
            if (bl2 && fieldDefinition == null) break;
            if (!bl3 && fieldDefinition != null) {
                this.mappings.put(cronFieldName, CronMapper.returnOnZeroExpression(cronFieldName));
            }
            if (bl3 && fieldDefinition2 == null && fieldDefinition != null) {
                this.mappings.put(cronFieldName, CronMapper.returnAlwaysExpression(cronFieldName));
            }
            if (fieldDefinition2 == null || fieldDefinition == null) continue;
            if (CronFieldName.DAY_OF_WEEK.equals((Object)cronFieldName)) {
                this.mappings.put(cronFieldName, CronMapper.dayOfWeekMapping((DayOfWeekFieldDefinition)fieldDefinition2, (DayOfWeekFieldDefinition)fieldDefinition));
                continue;
            }
            if (CronFieldName.DAY_OF_MONTH.equals((Object)cronFieldName)) {
                this.mappings.put(cronFieldName, CronMapper.dayOfMonthMapping(fieldDefinition2, fieldDefinition));
                continue;
            }
            this.mappings.put(cronFieldName, CronMapper.returnSameExpression());
        }
    }

    private Map<CronFieldName, FieldDefinition> getFieldDefinitions(CronDefinition cronDefinition) {
        EnumMap<CronFieldName, FieldDefinition> enumMap = new EnumMap<CronFieldName, FieldDefinition>(CronFieldName.class);
        for (FieldDefinition fieldDefinition : cronDefinition.getFieldDefinitions()) {
            enumMap.put(fieldDefinition.getFieldName(), fieldDefinition);
        }
        return enumMap;
    }
}

