/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.field.constraint;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialChar;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class FieldConstraints
implements Serializable {
    private static final long serialVersionUID = -9112124669329704710L;
    private final Map<String, Integer> stringMapping;
    private final Map<Integer, Integer> intMapping;
    private final Set<SpecialChar> specialChars;
    private final Integer startRange;
    private final Integer endRange;
    private final boolean strictRange;

    public FieldConstraints(Map<String, Integer> map, Map<Integer, Integer> map2, Set<SpecialChar> set, int n2, int n3, boolean bl2) {
        this.stringMapping = Collections.unmodifiableMap(Preconditions.checkNotNull(map, "String mapping must not be null"));
        this.intMapping = Collections.unmodifiableMap(Preconditions.checkNotNull(map2, "Integer mapping must not be null"));
        this.specialChars = Collections.unmodifiableSet(Preconditions.checkNotNull(set, "Special (non-standard) chars set must not be null"));
        this.startRange = n2;
        this.endRange = n3;
        this.strictRange = bl2;
    }

    public int getStartRange() {
        return this.startRange;
    }

    public int getEndRange() {
        return this.endRange;
    }

    public Set<SpecialChar> getSpecialChars() {
        return this.specialChars;
    }

    public boolean isInRange(int n2) {
        return n2 >= this.getStartRange() && n2 <= this.getEndRange();
    }

    public boolean isPeriodInRange(int n2) {
        return n2 > 0 && n2 <= this.getEndRange() - this.getStartRange();
    }

    public Set<String> getStringMappingKeySet() {
        return this.stringMapping.keySet();
    }

    public Integer getStringMappingValue(String string) {
        return this.stringMapping.get(string);
    }

    public Integer getIntMappingValue(Integer n2) {
        return this.intMapping.get(n2);
    }

    public boolean isStrictRange() {
        return this.strictRange;
    }
}

