/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.field.definition;

import java.io.Serializable;
import java.util.Comparator;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraints;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class FieldDefinition
implements Serializable {
    private static final long serialVersionUID = 7285200909397193383L;
    private final CronFieldName fieldName;
    private final FieldConstraints constraints;
    private final boolean optional;

    public FieldDefinition(CronFieldName cronFieldName, FieldConstraints fieldConstraints) {
        this(cronFieldName, fieldConstraints, false);
    }

    public FieldDefinition(CronFieldName cronFieldName, FieldConstraints fieldConstraints, boolean bl2) {
        this.fieldName = Preconditions.checkNotNull(cronFieldName, "CronFieldName must not be null");
        this.constraints = Preconditions.checkNotNull(fieldConstraints, "FieldConstraints must not be null");
        this.optional = bl2;
    }

    public static Comparator<FieldDefinition> createFieldDefinitionComparator() {
        return Comparator.comparingInt(fieldDefinition -> fieldDefinition.getFieldName().getOrder());
    }

    public CronFieldName getFieldName() {
        return this.fieldName;
    }

    public FieldConstraints getConstraints() {
        return this.constraints;
    }

    public boolean isOptional() {
        return this.optional;
    }
}

