/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.field.expression.visitor;

import me.forseth11.easybackup.dependencies.cronutils.Function;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Always;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.And;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Between;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.QuestionMark;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.visitor.FieldExpressionVisitor;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.FieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.IntegerFieldValue;

public class ValueMappingFieldExpressionVisitor
implements FieldExpressionVisitor {
    private final Function<FieldValue<?>, FieldValue<?>> transform;

    public ValueMappingFieldExpressionVisitor(Function<FieldValue<?>, FieldValue<?>> function) {
        this.transform = function;
    }

    @Override
    public FieldExpression visit(Always always) {
        return always;
    }

    @Override
    public FieldExpression visit(And and) {
        And and2 = new And();
        for (FieldExpression fieldExpression : and.getExpressions()) {
            and2.and(this.visit(fieldExpression));
        }
        return and2;
    }

    @Override
    public FieldExpression visit(Between between) {
        FieldValue<?> fieldValue = this.transform.apply(between.getFrom());
        FieldValue<?> fieldValue2 = this.transform.apply(between.getTo());
        return new Between(fieldValue, fieldValue2);
    }

    @Override
    public FieldExpression visit(Every every) {
        return new Every((IntegerFieldValue)this.transform.apply(every.getPeriod()));
    }

    @Override
    public FieldExpression visit(On on) {
        return new On((IntegerFieldValue)this.transform.apply(on.getTime()), on.getSpecialChar(), on.getNth());
    }

    @Override
    public FieldExpression visit(QuestionMark questionMark) {
        return FieldExpression.questionMark();
    }

    @Override
    public FieldExpression visit(FieldExpression fieldExpression) {
        if (fieldExpression instanceof Always) {
            return this.visit((Always)fieldExpression);
        }
        if (fieldExpression instanceof And) {
            return this.visit((And)fieldExpression);
        }
        if (fieldExpression instanceof Between) {
            return this.visit((Between)fieldExpression);
        }
        if (fieldExpression instanceof Every) {
            return this.visit((Every)fieldExpression);
        }
        if (fieldExpression instanceof On) {
            return this.visit((On)fieldExpression);
        }
        if (fieldExpression instanceof QuestionMark) {
            return this.visit((QuestionMark)fieldExpression);
        }
        return fieldExpression;
    }
}

