/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.forseth11.easybackup.dependencies.cronutils.model.CompositeCron;
import me.forseth11.easybackup.dependencies.cronutils.model.Cron;
import me.forseth11.easybackup.dependencies.cronutils.model.SingleCron;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.time.CompositeExecutionTime;
import me.forseth11.easybackup.dependencies.cronutils.model.time.ExecutionTimeBuilder;

public interface ExecutionTime {
    public static ExecutionTime forCron(Cron cron) {
        if (cron instanceof SingleCron) {
            Map<CronFieldName, CronField> map = cron.retrieveFieldsAsMap();
            ExecutionTimeBuilder executionTimeBuilder = new ExecutionTimeBuilder(cron);
            block10: for (CronFieldName cronFieldName : CronFieldName.values()) {
                if (map.get((Object)cronFieldName) == null) continue;
                switch (cronFieldName) {
                    case SECOND: {
                        executionTimeBuilder.forSecondsMatching(map.get((Object)cronFieldName));
                        continue block10;
                    }
                    case MINUTE: {
                        executionTimeBuilder.forMinutesMatching(map.get((Object)cronFieldName));
                        continue block10;
                    }
                    case HOUR: {
                        executionTimeBuilder.forHoursMatching(map.get((Object)cronFieldName));
                        continue block10;
                    }
                    case DAY_OF_WEEK: {
                        executionTimeBuilder.forDaysOfWeekMatching(map.get((Object)cronFieldName));
                        continue block10;
                    }
                    case DAY_OF_MONTH: {
                        executionTimeBuilder.forDaysOfMonthMatching(map.get((Object)cronFieldName));
                        continue block10;
                    }
                    case MONTH: {
                        executionTimeBuilder.forMonthsMatching(map.get((Object)cronFieldName));
                        continue block10;
                    }
                    case YEAR: {
                        executionTimeBuilder.forYearsMatching(map.get((Object)cronFieldName));
                        continue block10;
                    }
                    case DAY_OF_YEAR: {
                        executionTimeBuilder.forDaysOfYearMatching(map.get((Object)cronFieldName));
                        continue block10;
                    }
                }
            }
            return executionTimeBuilder.build();
        }
        return new CompositeExecutionTime(((CompositeCron)cron).getCrons().parallelStream().map(ExecutionTime::forCron).collect(Collectors.toList()));
    }

    public Optional<ZonedDateTime> nextExecution(ZonedDateTime var1);

    public Optional<Duration> timeToNextExecution(ZonedDateTime var1);

    public Optional<ZonedDateTime> lastExecution(ZonedDateTime var1);

    public Optional<Duration> timeFromLastExecution(ZonedDateTime var1);

    public boolean isMatch(ZonedDateTime var1);
}

