/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.model.time.generator;

import java.time.DayOfWeek;
import java.time.LocalDate;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.NoSuchValueException;
import me.forseth11.easybackup.dependencies.cronutils.model.time.generator.OnDayOfCalendarValueGenerator;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

class OnDayOfMonthValueGenerator
extends OnDayOfCalendarValueGenerator {
    public OnDayOfMonthValueGenerator(CronField cronField, int n2, int n3) {
        super(cronField, n2, n3);
        Preconditions.checkArgument(CronFieldName.DAY_OF_MONTH.equals((Object)cronField.getField()), "CronField does not belong to day of month");
    }

    @Override
    public int generateNextValue(int n2) {
        On on = (On)this.cronField.getExpression();
        int n3 = this.generateValue(on, this.year, this.month);
        if (n3 <= n2) {
            throw new NoSuchValueException();
        }
        return n3;
    }

    @Override
    public int generatePreviousValue(int n2) {
        On on = (On)this.cronField.getExpression();
        int n3 = this.generateValue(on, this.year, this.month);
        if (n3 >= n2) {
            throw new NoSuchValueException();
        }
        return n3;
    }

    @Override
    public boolean isMatch(int n2) {
        On on = (On)this.cronField.getExpression();
        try {
            return n2 == this.generateValue(on, this.year, this.month);
        }
        catch (NoSuchValueException noSuchValueException) {
            return false;
        }
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof On;
    }

    private int generateValue(On on, int n2, int n3) {
        int n4 = on.getTime().getValue();
        switch (on.getSpecialChar().getValue()) {
            case L: {
                int n5 = on.getNth().getValue();
                return LocalDate.of(n2, n3, 1).lengthOfMonth() - (n5 > 0 ? n5 : 0);
            }
            case W: {
                LocalDate localDate = LocalDate.of(n2, n3, n4);
                if (localDate.getDayOfWeek() == DayOfWeek.SATURDAY) {
                    if (n4 == 1) {
                        return 3;
                    }
                    return n4 - 1;
                }
                if (localDate.getDayOfWeek() == DayOfWeek.SUNDAY && n4 + 1 <= localDate.lengthOfMonth()) {
                    return n4 + 1;
                }
                return n4;
            }
            case LW: {
                LocalDate localDate = LocalDate.of(n2, n3, LocalDate.of(n2, n3, 1).lengthOfMonth());
                int n6 = localDate.getDayOfWeek().getValue();
                int n7 = n6 - 5;
                if (n7 > 0) {
                    return localDate.minusDays(n7).getDayOfMonth();
                }
                return localDate.getDayOfMonth();
            }
        }
        throw new NoSuchValueException();
    }
}

