/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.parser;

import java.util.Comparator;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraints;
import me.forseth11.easybackup.dependencies.cronutils.parser.FieldParser;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class CronParserField {
    private final CronFieldName field;
    private final FieldConstraints constraints;
    private final FieldParser parser;
    private final boolean optional;

    public CronParserField(CronFieldName cronFieldName, FieldConstraints fieldConstraints) {
        this(cronFieldName, fieldConstraints, false);
    }

    public CronParserField(CronFieldName cronFieldName, FieldConstraints fieldConstraints, boolean bl2) {
        this.field = Preconditions.checkNotNull(cronFieldName, "CronFieldName must not be null");
        this.constraints = Preconditions.checkNotNull(fieldConstraints, "FieldConstraints must not be null");
        this.parser = new FieldParser(fieldConstraints);
        this.optional = bl2;
    }

    public static Comparator<CronParserField> createFieldTypeComparator() {
        return Comparator.comparingInt(cronParserField -> cronParserField.getField().getOrder());
    }

    public CronFieldName getField() {
        return this.field;
    }

    public final boolean isOptional() {
        return this.optional;
    }

    public CronField parse(String string) {
        Integer n2;
        String string2 = string;
        if (this.getField().equals((Object)CronFieldName.DAY_OF_WEEK) && string2.endsWith("L") && (n2 = this.constraints.getStringMappingValue(string2.substring(0, string2.length() - 1))) != null) {
            string2 = n2 + "L";
        }
        return new CronField(this.field, this.parser.parse(string2), this.constraints);
    }

    public String toString() {
        return "CronParserField{field=" + (Object)((Object)this.field) + '}';
    }
}

