/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.parser;

import java.util.regex.Pattern;
import me.forseth11.easybackup.dependencies.cronutils.StringValidations;
import me.forseth11.easybackup.dependencies.cronutils.model.field.constraint.FieldConstraints;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.And;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Between;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.FieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.IntegerFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialChar;
import me.forseth11.easybackup.dependencies.cronutils.model.field.value.SpecialCharFieldValue;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;
import me.forseth11.easybackup.dependencies.cronutils.utils.StringUtils;
import me.forseth11.easybackup.dependencies.cronutils.utils.VisibleForTesting;

public class FieldParser {
    private static final String SLASH = "/";
    private static final String W_STRING = "W";
    private static final String EMPTY_STRING = "";
    private static final String LW_STRING = "LW";
    private static final String HASH_TAG = "#";
    private static final String L_STRING = "L";
    private static final String QUESTION_MARK_STRING = "?";
    private static final String ASTERISK = "*";
    private static final char[] SPECIAL_CHARS_MINUS_STAR = new char[]{'/', '-', ','};
    private static final Pattern L_PATTERN = Pattern.compile("[0-9]L", 2);
    private static final Pattern W_PATTERN = Pattern.compile("[0-9]W", 2);
    private static final String ASTERISK_ALWAYS_VALUE = "1";
    private final FieldConstraints fieldConstraints;

    public FieldParser(FieldConstraints fieldConstraints) {
        this.fieldConstraints = Preconditions.checkNotNull(fieldConstraints, "FieldConstraints must not be null");
    }

    public FieldExpression parse(String string) {
        if (!StringUtils.containsAny(string, SPECIAL_CHARS_MINUS_STAR)) {
            if (string.contains(QUESTION_MARK_STRING) && !this.fieldConstraints.getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
                throw new IllegalArgumentException("Invalid expression: " + string);
            }
            return this.noSpecialCharsNorStar(string);
        }
        String[] stringArray = string.split(",");
        if (stringArray.length > 1) {
            return this.commaSplitResult(stringArray);
        }
        String[] stringArray2 = string.split("-");
        if (string.contains("-") && stringArray2.length != 2) {
            throw new IllegalArgumentException("Missing values for range: " + string);
        }
        return stringArray2[0].equalsIgnoreCase(L_STRING) ? this.parseOnWithL(stringArray2[0], this.mapToIntegerFieldValue(stringArray2[1])) : this.dashSplitResult(string, stringArray2);
    }

    private FieldExpression dashSplitResult(String string, String[] stringArray) {
        if (stringArray.length > 1) {
            return this.parseBetween(stringArray);
        }
        return this.slashSplit(string, string.split(SLASH));
    }

    private FieldExpression commaSplitResult(String[] stringArray) {
        And and = new And();
        for (String string : stringArray) {
            and.and(this.parse(string));
        }
        return and;
    }

    private FieldExpression slashSplit(String string, String[] stringArray) {
        if (stringArray.length == 2) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            return this.asteriskOrempty(string2, string3);
        }
        if (stringArray.length == 1) {
            throw new IllegalArgumentException("Missing steps for expression: " + string);
        }
        throw new IllegalArgumentException("Invalid expression: " + string);
    }

    private FieldExpression asteriskOrempty(String string, String string2) {
        String string3 = string.trim();
        if (ASTERISK.equals(string3) && string2.equals(ASTERISK_ALWAYS_VALUE)) {
            return this.noSpecialCharsNorStar(string);
        }
        if (ASTERISK.equals(string3) || EMPTY_STRING.equals(string.trim())) {
            return new Every(new IntegerFieldValue(Integer.parseInt(string2)));
        }
        return new Every(new On(new IntegerFieldValue(Integer.parseInt(string))), new IntegerFieldValue(Integer.parseInt(string2)));
    }

    private FieldExpression noSpecialCharsNorStar(String string) {
        if (ASTERISK.equals(string)) {
            return FieldExpression.always();
        }
        if (QUESTION_MARK_STRING.equals(string)) {
            return FieldExpression.questionMark();
        }
        return this.parseOn(string);
    }

    @VisibleForTesting
    protected FieldExpression parseBetween(String[] stringArray) {
        if (stringArray[0].isEmpty() || stringArray[1].isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid expression! Expression: %s-%s does not describe a range. Negative numbers are not allowed.", stringArray[0], stringArray[1]));
        }
        if (stringArray[1].contains(SLASH)) {
            String[] stringArray2 = stringArray[1].split(SLASH);
            return new Every(new Between(this.map(stringArray[0]), this.map(stringArray2[0])), this.mapToIntegerFieldValue(stringArray2[1]));
        }
        return new Between(this.map(stringArray[0]), this.map(stringArray[1]));
    }

    @VisibleForTesting
    protected On parseOn(String string) {
        if (QUESTION_MARK_STRING.equals(string)) {
            return this.parseOnWithQuestionMark(string);
        }
        if (string.contains(HASH_TAG)) {
            return this.parseOnWithHash(string);
        }
        if (string.contains(LW_STRING)) {
            return this.parseOnWithLW(string);
        }
        if (L_PATTERN.matcher(string).find() || string.equalsIgnoreCase(L_STRING)) {
            return this.parseOnWithL(string);
        }
        if (W_PATTERN.matcher(string).find()) {
            return this.parseOnWithW(string);
        }
        return new On(this.mapToIntegerFieldValue(string), new SpecialCharFieldValue(SpecialChar.NONE), new IntegerFieldValue(-1));
    }

    @VisibleForTesting
    protected On parseOnWithHash(String string) {
        if (!this.fieldConstraints.getSpecialChars().contains((Object)SpecialChar.HASH)) {
            throw new IllegalArgumentException("Invalid expression: " + string);
        }
        SpecialCharFieldValue specialCharFieldValue = new SpecialCharFieldValue(SpecialChar.HASH);
        String[] stringArray = string.split(HASH_TAG);
        IntegerFieldValue integerFieldValue = this.mapToIntegerFieldValue(stringArray[1]);
        if (stringArray[0].isEmpty()) {
            throw new IllegalArgumentException("Time should be specified!");
        }
        return new On(this.mapToIntegerFieldValue(stringArray[0]), specialCharFieldValue, integerFieldValue);
    }

    @VisibleForTesting
    protected On parseOnWithQuestionMark(String string) {
        SpecialCharFieldValue specialCharFieldValue = new SpecialCharFieldValue(SpecialChar.QUESTION_MARK);
        String string2 = string.replace(QUESTION_MARK_STRING, EMPTY_STRING);
        if (EMPTY_STRING.equals(string2)) {
            return new On(new IntegerFieldValue(-1), specialCharFieldValue, new IntegerFieldValue(-1));
        }
        throw new IllegalArgumentException(String.format("Expected: '?', found: %s", string2));
    }

    @VisibleForTesting
    protected On parseOnWithLW(String string) {
        SpecialCharFieldValue specialCharFieldValue = new SpecialCharFieldValue(SpecialChar.LW);
        String string2 = string.replace(LW_STRING, EMPTY_STRING);
        if (EMPTY_STRING.equals(string2)) {
            return new On(new IntegerFieldValue(-1), specialCharFieldValue, new IntegerFieldValue(-1));
        }
        throw new IllegalArgumentException(String.format("Expected: LW, found: %s", string2));
    }

    @VisibleForTesting
    protected On parseOnWithL(String string) {
        return this.parseOnWithL(string, new IntegerFieldValue(-1));
    }

    protected On parseOnWithL(String string, IntegerFieldValue integerFieldValue) {
        SpecialCharFieldValue specialCharFieldValue = new SpecialCharFieldValue(SpecialChar.L);
        String string2 = string.replace(L_STRING, EMPTY_STRING);
        IntegerFieldValue integerFieldValue2 = new IntegerFieldValue(-1);
        if (!EMPTY_STRING.equals(string2)) {
            integerFieldValue2 = this.mapToIntegerFieldValue(string2);
        }
        return new On(integerFieldValue2, specialCharFieldValue, integerFieldValue);
    }

    @VisibleForTesting
    protected On parseOnWithW(String string) {
        return new On(this.mapToIntegerFieldValue(string.replace(W_STRING, EMPTY_STRING)), new SpecialCharFieldValue(SpecialChar.W), new IntegerFieldValue(-1));
    }

    @VisibleForTesting
    protected IntegerFieldValue mapToIntegerFieldValue(String string) {
        try {
            return new IntegerFieldValue(this.intToInt(this.stringToInt(string)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("Invalid value. Expected some integer, found %s", string));
        }
    }

    @VisibleForTesting
    protected FieldValue<?> map(String string) {
        for (SpecialChar specialChar : SpecialChar.values()) {
            if (!specialChar.toString().equals(string)) continue;
            return new SpecialCharFieldValue(specialChar);
        }
        return new IntegerFieldValue(this.stringToInt(string));
    }

    @VisibleForTesting
    protected int stringToInt(String string) {
        Integer n2 = this.fieldConstraints.getStringMappingValue(string);
        if (n2 != null) {
            return n2;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = new StringValidations(this.fieldConstraints).removeValidChars(string);
            throw new IllegalArgumentException(String.format("Invalid chars in expression! Expression: %s Invalid chars: %s", string, string2));
        }
    }

    @VisibleForTesting
    protected int intToInt(Integer n2) {
        Integer n3 = this.fieldConstraints.getIntMappingValue(n2);
        if (n3 != null) {
            return n3;
        }
        return n2;
    }
}

