/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.utils;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import me.forseth11.easybackup.dependencies.cronutils.utils.WeekendPolicy;

public class DateUtils {
    private DateUtils() {
    }

    public static int workdaysCount(ZonedDateTime zonedDateTime, int n2, List<ZonedDateTime> list, WeekendPolicy weekendPolicy) {
        return DateUtils.workdaysCount(zonedDateTime, zonedDateTime.plusDays(n2), list, weekendPolicy);
    }

    public static int workdaysCount(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, List<ZonedDateTime> list, WeekendPolicy weekendPolicy) {
        Collections.sort(list);
        list = DateUtils.holidaysInRange(zonedDateTime, zonedDateTime2, list);
        int n2 = WeekendPolicy.daysToWeekend(weekendPolicy, zonedDateTime);
        int n3 = WeekendPolicy.daysFromWeekend(weekendPolicy, zonedDateTime2);
        int n4 = (int)Duration.between(zonedDateTime, zonedDateTime2).toDays() + 1;
        int n5 = (n4 - n2 - n3 - 2) / 7 * 5;
        return (n5 -= list.size()) + n2 + n3;
    }

    private static List<ZonedDateTime> holidaysInRange(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, List<ZonedDateTime> list) {
        if (list.isEmpty()) {
            return list;
        }
        int n2 = DateUtils.findIdx(0, list.size() - 1, zonedDateTime, list);
        int n3 = DateUtils.findIdx(0, list.size() - 1, zonedDateTime2, list);
        return list.subList(n2, n3 + 1);
    }

    private static int findIdx(int n2, int n3, ZonedDateTime zonedDateTime, List<ZonedDateTime> list) {
        if (n2 == n3) {
            return n2;
        }
        int n4 = (n3 - n2) / 2;
        if (list.get(n4).equals(zonedDateTime)) {
            return n4;
        }
        if (list.get(n4).isBefore(zonedDateTime)) {
            return DateUtils.findIdx(++n4, n3, zonedDateTime, list);
        }
        return DateUtils.findIdx(n2, n4, zonedDateTime, list);
    }
}

