/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.utils;

import java.time.ZonedDateTime;

public enum WeekendPolicy {
    THURSDAY_FRIDAY,
    FRIDAY_SATURDAY,
    SATURDAY_SUNDAY;


    public static int daysToWeekend(WeekendPolicy weekendPolicy, ZonedDateTime zonedDateTime) {
        int n2 = zonedDateTime.getDayOfWeek().getValue();
        switch (weekendPolicy) {
            case THURSDAY_FRIDAY: {
                if (n2 < 4) {
                    return 4 - n2;
                }
                if (n2 <= 5) break;
                return 7 - n2 + 4;
            }
            case FRIDAY_SATURDAY: {
                if (n2 < 5) {
                    return 6 - n2;
                }
                if (n2 <= 6) break;
                return 7 - n2 + 5;
            }
            case SATURDAY_SUNDAY: {
                if (n2 >= 6) break;
                return Math.max(0, 6 - n2);
            }
        }
        return 0;
    }

    public static int daysFromWeekend(WeekendPolicy weekendPolicy, ZonedDateTime zonedDateTime) {
        int n2 = zonedDateTime.getDayOfWeek().getValue();
        switch (weekendPolicy) {
            case THURSDAY_FRIDAY: {
                if (n2 < 4) {
                    return n2;
                }
                if (n2 <= 5) break;
                return n2 - 5;
            }
            case FRIDAY_SATURDAY: {
                if (n2 < 5) {
                    return n2;
                }
                if (n2 <= 6) break;
                return n2 - 6;
            }
            case SATURDAY_SUNDAY: {
                if (n2 >= 6) break;
                return n2;
            }
        }
        return 0;
    }
}

