/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.prettytime.i18n;

import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.forseth11.easybackup.dependencies.prettytime.Duration;
import me.forseth11.easybackup.dependencies.prettytime.TimeFormat;
import me.forseth11.easybackup.dependencies.prettytime.TimeUnit;
import me.forseth11.easybackup.dependencies.prettytime.format.SimpleTimeFormat;
import me.forseth11.easybackup.dependencies.prettytime.impl.TimeFormatProvider;
import me.forseth11.easybackup.dependencies.prettytime.units.Day;

public class Resources_fi
extends ListResourceBundle
implements TimeFormatProvider {
    private static final int tolerance = 50;
    private static Object[][] CONTENTS = new Object[][]{{"JustNowPattern", "%u"}, {"JustNowPastSingularName", "hetki"}, {"JustNowFutureSingularName", "hetken"}, {"JustNowPastSuffix", "sitten"}, {"JustNowFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"MillisecondPattern", "%u"}, {"MillisecondPluralPattern", "%n %u"}, {"MillisecondPastSingularName", "millisekunti"}, {"MillisecondPastPluralName", "millisekuntia"}, {"MillisecondFutureSingularName", "millisekunnin"}, {"MillisecondPastSuffix", "sitten"}, {"MillisecondFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"SecondPattern", "%u"}, {"SecondPluralPattern", "%n %u"}, {"SecondPastSingularName", "sekunti"}, {"SecondPastPluralName", "sekuntia"}, {"SecondFutureSingularName", "sekunnin"}, {"SecondPastSuffix", "sitten"}, {"SecondFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"MinutePattern", "%u"}, {"MinutePluralPattern", "%n %u"}, {"MinutePastSingularName", "minuutti"}, {"MinutePastPluralName", "minuuttia"}, {"MinuteFutureSingularName", "minuutin"}, {"MinutePastSuffix", "sitten"}, {"MinuteFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"HourPattern", "%u"}, {"HourPluralPattern", "%n %u"}, {"HourPastSingularName", "tunti"}, {"HourPastPluralName", "tuntia"}, {"HourFutureSingularName", "tunnin"}, {"HourPastSuffix", "sitten"}, {"HourFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"DayPattern", "%u"}, {"DayPluralPattern", "%n %u"}, {"DayPastSingularName", "eilen"}, {"DayPastPluralName", "p\u00e4iv\u00e4\u00e4"}, {"DayFutureSingularName", "huomenna"}, {"DayFuturePluralName", "p\u00e4iv\u00e4n"}, {"DayPastSuffix", "sitten"}, {"DayFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"WeekPattern", "%u"}, {"WeekPluralPattern", "%n %u"}, {"WeekPastSingularName", "viikko"}, {"WeekPastPluralName", "viikkoa"}, {"WeekFutureSingularName", "viikon"}, {"WeekFuturePluralName", "viikon"}, {"WeekPastSuffix", "sitten"}, {"WeekFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"MonthPattern", "%u"}, {"MonthPluralPattern", "%n %u"}, {"MonthPastSingularName", "kuukausi"}, {"MonthPastPluralName", "kuukautta"}, {"MonthFutureSingularName", "kuukauden"}, {"MonthPastSuffix", "sitten"}, {"MonthFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"YearPattern", "%u"}, {"YearPluralPattern", "%n %u"}, {"YearPastSingularName", "vuosi"}, {"YearPastPluralName", "vuotta"}, {"YearFutureSingularName", "vuoden"}, {"YearPastSuffix", "sitten"}, {"YearFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"DecadePattern", "%u"}, {"DecadePluralPattern", "%n %u"}, {"DecadePastSingularName", "vuosikymmen"}, {"DecadePastPluralName", "vuosikymment\u00e4"}, {"DecadeFutureSingularName", "vuosikymmenen"}, {"DecadePastSuffix", "sitten"}, {"DecadeFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"CenturyPattern", "%u"}, {"CenturyPluralPattern", "%n %u"}, {"CenturyPastSingularName", "vuosisata"}, {"CenturyPastPluralName", "vuosisataa"}, {"CenturyFutureSingularName", "vuosisadan"}, {"CenturyPastSuffix", "sitten"}, {"CenturyFutureSuffix", "p\u00e4\u00e4st\u00e4"}, {"MillenniumPattern", "%u"}, {"MillenniumPluralPattern", "%n %u"}, {"MillenniumPastSingularName", "vuosituhat"}, {"MillenniumPastPluralName", "vuosituhatta"}, {"MillenniumFutureSingularName", "vuosituhannen"}, {"MillenniumPastSuffix", "sitten"}, {"MillenniumFutureSuffix", "p\u00e4\u00e4st\u00e4"}};
    private volatile ConcurrentMap<TimeUnit, TimeFormat> formatMap = new ConcurrentHashMap<TimeUnit, TimeFormat>();

    @Override
    public TimeFormat getFormatFor(TimeUnit timeUnit) {
        if (!this.formatMap.containsKey(timeUnit)) {
            this.formatMap.putIfAbsent(timeUnit, new FiTimeFormat(this, timeUnit));
        }
        return (TimeFormat)this.formatMap.get(timeUnit);
    }

    @Override
    protected Object[][] getContents() {
        return CONTENTS;
    }

    private static class FiTimeFormat
    extends SimpleTimeFormat {
        private final ResourceBundle bundle;
        private String pastName = "";
        private String futureName = "";
        private String pastPluralName = "";
        private String futurePluralName = "";
        private String pluralPattern = "";

        public FiTimeFormat(ResourceBundle resourceBundle, TimeUnit timeUnit) {
            this.bundle = resourceBundle;
            if (this.bundle.containsKey(this.getUnitName(timeUnit) + "PastSingularName")) {
                this.setPastName(this.bundle.getString(this.getUnitName(timeUnit) + "PastSingularName")).setFutureName(this.bundle.getString(this.getUnitName(timeUnit) + "FutureSingularName")).setPastPluralName(this.bundle.getString(this.getUnitName(timeUnit) + "PastSingularName")).setFuturePluralName(this.bundle.getString(this.getUnitName(timeUnit) + "FutureSingularName")).setPluralPattern(this.bundle.getString(this.getUnitName(timeUnit) + "Pattern"));
                if (this.bundle.containsKey(this.getUnitName(timeUnit) + "PastPluralName")) {
                    this.setPastPluralName(this.bundle.getString(this.getUnitName(timeUnit) + "PastPluralName"));
                }
                if (this.bundle.containsKey(this.getUnitName(timeUnit) + "FuturePluralName")) {
                    this.setFuturePluralName(this.bundle.getString(this.getUnitName(timeUnit) + "FuturePluralName"));
                }
                if (this.bundle.containsKey(this.getUnitName(timeUnit) + "PluralPattern")) {
                    this.setPluralPattern(this.bundle.getString(this.getUnitName(timeUnit) + "PluralPattern"));
                }
                this.setPattern(this.bundle.getString(this.getUnitName(timeUnit) + "Pattern")).setPastSuffix(this.bundle.getString(this.getUnitName(timeUnit) + "PastSuffix")).setFutureSuffix(this.bundle.getString(this.getUnitName(timeUnit) + "FutureSuffix")).setFuturePrefix("").setPastPrefix("").setSingularName("").setPluralName("");
            }
        }

        public String getPastName() {
            return this.pastName;
        }

        public String getFutureName() {
            return this.futureName;
        }

        public String getPastPluralName() {
            return this.pastPluralName;
        }

        public String getFuturePluralName() {
            return this.futurePluralName;
        }

        public String getPluralPattern() {
            return this.pluralPattern;
        }

        public FiTimeFormat setPastName(String string) {
            this.pastName = string;
            return this;
        }

        public FiTimeFormat setFutureName(String string) {
            this.futureName = string;
            return this;
        }

        @Override
        public FiTimeFormat setPastPluralName(String string) {
            this.pastPluralName = string;
            return this;
        }

        @Override
        public FiTimeFormat setFuturePluralName(String string) {
            this.futurePluralName = string;
            return this;
        }

        public FiTimeFormat setPluralPattern(String string) {
            this.pluralPattern = string;
            return this;
        }

        @Override
        protected String getGramaticallyCorrectName(Duration duration, boolean bl2) {
            String string;
            String string2 = string = duration.isInPast() ? this.getPastName() : this.getFutureName();
            if (Math.abs(this.getQuantity(duration, bl2)) == 0L || Math.abs(this.getQuantity(duration, bl2)) > 1L) {
                string = duration.isInPast() ? this.getPastPluralName() : this.getFuturePluralName();
            }
            return string;
        }

        @Override
        protected String getPattern(long l2) {
            if (Math.abs(l2) == 1L) {
                return this.getPattern();
            }
            return this.getPluralPattern();
        }

        @Override
        public String decorate(Duration duration, String string) {
            String string2 = "";
            string2 = duration.getUnit() instanceof Day && Math.abs(duration.getQuantityRounded(50)) == 1L ? string : super.decorate(duration, string);
            return string2;
        }

        private String getUnitName(TimeUnit timeUnit) {
            return timeUnit.getClass().getSimpleName();
        }
    }
}

