/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.prettytime.i18n;

import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.forseth11.easybackup.dependencies.prettytime.Duration;
import me.forseth11.easybackup.dependencies.prettytime.TimeFormat;
import me.forseth11.easybackup.dependencies.prettytime.TimeUnit;
import me.forseth11.easybackup.dependencies.prettytime.impl.TimeFormatProvider;
import me.forseth11.easybackup.dependencies.prettytime.units.Decade;
import me.forseth11.easybackup.dependencies.prettytime.units.Millennium;

public class Resources_ja
extends ListResourceBundle
implements TimeFormatProvider {
    private static final Object[][] OBJECTS = new Object[][]{{"CenturyPattern", "%n%u"}, {"CenturyFuturePrefix", "\u4eca\u304b\u3089"}, {"CenturyFutureSuffix", "\u5f8c"}, {"CenturyPastPrefix", ""}, {"CenturyPastSuffix", "\u524d"}, {"CenturySingularName", "\u4e16\u7d00"}, {"CenturyPluralName", "\u4e16\u7d00"}, {"DayPattern", "%n%u"}, {"DayFuturePrefix", "\u4eca\u304b\u3089"}, {"DayFutureSuffix", "\u5f8c"}, {"DayPastPrefix", ""}, {"DayPastSuffix", "\u524d"}, {"DaySingularName", "\u65e5"}, {"DayPluralName", "\u65e5"}, {"DecadePattern", "%n%u"}, {"DecadeFuturePrefix", "\u4eca\u304b\u3089"}, {"DecadeFutureSuffix", "\u5f8c"}, {"DecadePastPrefix", ""}, {"DecadePastSuffix", "\u524d"}, {"DecadeSingularName", "\u5e74"}, {"DecadePluralName", "\u5e74"}, {"HourPattern", "%n%u"}, {"HourFuturePrefix", "\u4eca\u304b\u3089"}, {"HourFutureSuffix", "\u5f8c"}, {"HourPastPrefix", ""}, {"HourPastSuffix", "\u524d"}, {"HourSingularName", "\u6642\u9593"}, {"HourPluralName", "\u6642\u9593"}, {"JustNowPattern", "%u"}, {"JustNowFuturePrefix", "\u4eca\u304b\u3089"}, {"JustNowFutureSuffix", "\u3059\u3050"}, {"JustNowPastPrefix", ""}, {"JustNowPastSuffix", "\u305f\u3063\u305f\u4eca"}, {"JustNowSingularName", ""}, {"JustNowPluralName", ""}, {"MillenniumPattern", "%n%u"}, {"MillenniumFuturePrefix", "\u4eca\u304b\u3089"}, {"MillenniumFutureSuffix", "\u5f8c"}, {"MillenniumPastPrefix", ""}, {"MillenniumPastSuffix", "\u524d"}, {"MillenniumSingularName", "\u5e74"}, {"MillenniumPluralName", "\u5e74"}, {"MillisecondPattern", "%n%u"}, {"MillisecondFuturePrefix", "\u4eca\u304b\u3089"}, {"MillisecondFutureSuffix", "\u5f8c"}, {"MillisecondPastPrefix", ""}, {"MillisecondPastSuffix", "\u524d"}, {"MillisecondSingularName", "\u30df\u30ea\u79d2"}, {"MillisecondPluralName", "\u30df\u30ea\u79d2"}, {"MinutePattern", "%n%u"}, {"MinuteFuturePrefix", "\u4eca\u304b\u3089"}, {"MinuteFutureSuffix", "\u5f8c"}, {"MinutePastPrefix", ""}, {"MinutePastSuffix", "\u524d"}, {"MinuteSingularName", "\u5206"}, {"MinutePluralName", "\u5206"}, {"MonthPattern", "%n%u"}, {"MonthFuturePrefix", "\u4eca\u304b\u3089"}, {"MonthFutureSuffix", "\u5f8c"}, {"MonthPastPrefix", ""}, {"MonthPastSuffix", "\u524d"}, {"MonthSingularName", "\u30f6\u6708"}, {"MonthPluralName", "\u30f6\u6708"}, {"SecondPattern", "%n%u"}, {"SecondFuturePrefix", "\u4eca\u304b\u3089"}, {"SecondFutureSuffix", "\u5f8c"}, {"SecondPastPrefix", ""}, {"SecondPastSuffix", "\u524d"}, {"SecondSingularName", "\u79d2"}, {"SecondPluralName", "\u79d2"}, {"WeekPattern", "%n%u"}, {"WeekFuturePrefix", "\u4eca\u304b\u3089"}, {"WeekFutureSuffix", "\u5f8c"}, {"WeekPastPrefix", ""}, {"WeekPastSuffix", "\u524d"}, {"WeekSingularName", "\u9031\u9593"}, {"WeekPluralName", "\u9031\u9593"}, {"YearPattern", "%n%u"}, {"YearFuturePrefix", "\u4eca\u304b\u3089"}, {"YearFutureSuffix", "\u5f8c"}, {"YearPastPrefix", ""}, {"YearPastSuffix", "\u524d"}, {"YearSingularName", "\u5e74"}, {"YearPluralName", "\u5e74"}, {"AbstractTimeUnitPattern", ""}, {"AbstractTimeUnitFuturePrefix", ""}, {"AbstractTimeUnitFutureSuffix", ""}, {"AbstractTimeUnitPastPrefix", ""}, {"AbstractTimeUnitPastSuffix", ""}, {"AbstractTimeUnitSingularName", ""}, {"AbstractTimeUnitPluralName", ""}};
    private volatile ConcurrentMap<TimeUnit, TimeFormat> formatMap = new ConcurrentHashMap<TimeUnit, TimeFormat>();

    @Override
    public Object[][] getContents() {
        return OBJECTS;
    }

    @Override
    public TimeFormat getFormatFor(TimeUnit timeUnit) {
        if (!this.formatMap.containsKey(timeUnit)) {
            this.formatMap.putIfAbsent(timeUnit, new JaTimeFormat(this, timeUnit));
        }
        return (TimeFormat)this.formatMap.get(timeUnit);
    }

    private static class JaTimeFormat
    implements TimeFormat {
        private static final String NEGATIVE = "-";
        public static final String SIGN = "%s";
        public static final String QUANTITY = "%n";
        public static final String UNIT = "%u";
        private final ResourceBundle bundle;
        private String singularName = "";
        private String pluralName = "";
        private String futureSingularName = "";
        private String futurePluralName = "";
        private String pastSingularName = "";
        private String pastPluralName = "";
        private String pattern = "";
        private String futurePrefix = "";
        private String futureSuffix = "";
        private String pastPrefix = "";
        private String pastSuffix = "";
        private int roundingTolerance = 50;

        public JaTimeFormat(ResourceBundle resourceBundle, TimeUnit timeUnit) {
            this.bundle = resourceBundle;
            this.setPattern(resourceBundle.getString(this.getUnitName(timeUnit) + "Pattern"));
            this.setFuturePrefix(resourceBundle.getString(this.getUnitName(timeUnit) + "FuturePrefix"));
            this.setFutureSuffix(resourceBundle.getString(this.getUnitName(timeUnit) + "FutureSuffix"));
            this.setPastPrefix(resourceBundle.getString(this.getUnitName(timeUnit) + "PastPrefix"));
            this.setPastSuffix(resourceBundle.getString(this.getUnitName(timeUnit) + "PastSuffix"));
            this.setSingularName(resourceBundle.getString(this.getUnitName(timeUnit) + "SingularName"));
            this.setPluralName(resourceBundle.getString(this.getUnitName(timeUnit) + "PluralName"));
            try {
                this.setFuturePluralName(resourceBundle.getString(this.getUnitName(timeUnit) + "FuturePluralName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setFutureSingularName(resourceBundle.getString(this.getUnitName(timeUnit) + "FutureSingularName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setPastPluralName(resourceBundle.getString(this.getUnitName(timeUnit) + "PastPluralName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setPastSingularName(resourceBundle.getString(this.getUnitName(timeUnit) + "PastSingularName"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private String getUnitName(TimeUnit timeUnit) {
            return timeUnit.getClass().getSimpleName();
        }

        @Override
        public String format(Duration duration) {
            return this.format(duration, true);
        }

        @Override
        public String formatUnrounded(Duration duration) {
            return this.format(duration, false);
        }

        private String format(Duration duration, boolean bl2) {
            String string = this.getSign(duration);
            String string2 = this.getGramaticallyCorrectName(duration, bl2);
            long l2 = this.getQuantity(duration, bl2);
            if (duration.getUnit() instanceof Decade) {
                l2 *= 10L;
            }
            if (duration.getUnit() instanceof Millennium) {
                l2 *= 1000L;
            }
            return this.applyPattern(string, string2, l2);
        }

        private String applyPattern(String string, String string2, long l2) {
            String string3 = this.getPattern(l2).replaceAll(SIGN, string);
            string3 = string3.replaceAll(QUANTITY, String.valueOf(l2));
            string3 = string3.replaceAll(UNIT, string2);
            return string3;
        }

        protected String getPattern(long l2) {
            return this.pattern;
        }

        public String getPattern() {
            return this.pattern;
        }

        protected long getQuantity(Duration duration, boolean bl2) {
            return Math.abs(bl2 ? duration.getQuantityRounded(this.roundingTolerance) : duration.getQuantity());
        }

        protected String getGramaticallyCorrectName(Duration duration, boolean bl2) {
            String string = this.getSingularName(duration);
            if (Math.abs(this.getQuantity(duration, bl2)) == 0L || Math.abs(this.getQuantity(duration, bl2)) > 1L) {
                string = this.getPluralName(duration);
            }
            return string;
        }

        private String getSign(Duration duration) {
            if (duration.getQuantity() < 0L) {
                return NEGATIVE;
            }
            return "";
        }

        private String getSingularName(Duration duration) {
            if (duration.isInFuture() && this.futureSingularName != null && this.futureSingularName.length() > 0) {
                return this.futureSingularName;
            }
            if (duration.isInPast() && this.pastSingularName != null && this.pastSingularName.length() > 0) {
                return this.pastSingularName;
            }
            return this.singularName;
        }

        private String getPluralName(Duration duration) {
            if (duration.isInFuture() && this.futurePluralName != null && this.futureSingularName.length() > 0) {
                return this.futurePluralName;
            }
            if (duration.isInPast() && this.pastPluralName != null && this.pastSingularName.length() > 0) {
                return this.pastPluralName;
            }
            return this.pluralName;
        }

        @Override
        public String decorate(Duration duration, String string) {
            StringBuilder stringBuilder = new StringBuilder();
            if (duration.isInPast()) {
                stringBuilder.append(this.pastPrefix).append(string).append(this.pastSuffix);
            } else {
                stringBuilder.append(this.futurePrefix).append(string).append(this.futureSuffix);
            }
            return stringBuilder.toString().replaceAll("\\s+", " ").trim();
        }

        @Override
        public String decorateUnrounded(Duration duration, String string) {
            return this.decorate(duration, string);
        }

        public JaTimeFormat setPattern(String string) {
            this.pattern = string;
            return this;
        }

        public JaTimeFormat setFuturePrefix(String string) {
            this.futurePrefix = string.trim();
            return this;
        }

        public JaTimeFormat setFutureSuffix(String string) {
            this.futureSuffix = string.trim();
            return this;
        }

        public JaTimeFormat setPastPrefix(String string) {
            this.pastPrefix = string.trim();
            return this;
        }

        public JaTimeFormat setPastSuffix(String string) {
            this.pastSuffix = string.trim();
            return this;
        }

        public JaTimeFormat setRoundingTolerance(int n2) {
            this.roundingTolerance = n2;
            return this;
        }

        public JaTimeFormat setSingularName(String string) {
            this.singularName = string;
            return this;
        }

        public JaTimeFormat setPluralName(String string) {
            this.pluralName = string;
            return this;
        }

        public JaTimeFormat setFutureSingularName(String string) {
            this.futureSingularName = string;
            return this;
        }

        public JaTimeFormat setFuturePluralName(String string) {
            this.futurePluralName = string;
            return this;
        }

        public JaTimeFormat setPastSingularName(String string) {
            this.pastSingularName = string;
            return this;
        }

        public JaTimeFormat setPastPluralName(String string) {
            this.pastPluralName = string;
            return this;
        }

        public String toString() {
            return "JaTimeFormat [pattern=" + this.pattern + ", futurePrefix=" + this.futurePrefix + ", futureSuffix=" + this.futureSuffix + ", pastPrefix=" + this.pastPrefix + ", pastSuffix=" + this.pastSuffix + ", roundingTolerance=" + this.roundingTolerance + "]";
        }
    }
}

