/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.crypto;

import java.util.Arrays;
import me.forseth11.easybackup.dependencies.zip4j.crypto.AesCipherUtil;
import me.forseth11.easybackup.dependencies.zip4j.crypto.Decrypter;
import me.forseth11.easybackup.dependencies.zip4j.crypto.PBKDF2.MacBasedPRF;
import me.forseth11.easybackup.dependencies.zip4j.crypto.engine.AESEngine;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.model.AESExtraDataRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.AesKeyStrength;

public class AESDecrypter
implements Decrypter {
    private AESEngine aesEngine;
    private MacBasedPRF mac;
    private int nonce = 1;
    private byte[] iv = new byte[16];
    private byte[] counterBlock = new byte[16];

    public AESDecrypter(AESExtraDataRecord aESExtraDataRecord, char[] cArray, byte[] byArray, byte[] byArray2) {
        this.init(byArray, byArray2, cArray, aESExtraDataRecord);
    }

    private void init(byte[] byArray, byte[] byArray2, char[] cArray, AESExtraDataRecord aESExtraDataRecord) {
        if (cArray == null || cArray.length <= 0) {
            throw new ZipException("empty or null password provided for AES decryption");
        }
        AesKeyStrength aesKeyStrength = aESExtraDataRecord.getAesKeyStrength();
        byte[] byArray3 = AesCipherUtil.derivePasswordBasedKey(byArray, cArray, aesKeyStrength);
        byte[] byArray4 = AesCipherUtil.derivePasswordVerifier(byArray3, aesKeyStrength);
        if (!Arrays.equals(byArray2, byArray4)) {
            throw new ZipException("Wrong Password", ZipException.Type.WRONG_PASSWORD);
        }
        this.aesEngine = AesCipherUtil.getAESEngine(byArray3, aesKeyStrength);
        this.mac = AesCipherUtil.getMacBasedPRF(byArray3, aesKeyStrength);
    }

    @Override
    public int decryptData(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; i2 += 16) {
            int n4 = i2 + 16 <= n2 + n3 ? 16 : n2 + n3 - i2;
            this.mac.update(byArray, i2, n4);
            AesCipherUtil.prepareBuffAESIVBytes(this.iv, this.nonce);
            this.aesEngine.processBlock(this.iv, this.counterBlock);
            for (int i3 = 0; i3 < n4; ++i3) {
                byArray[i2 + i3] = (byte)(byArray[i2 + i3] ^ this.counterBlock[i3]);
            }
            ++this.nonce;
        }
        return n3;
    }

    public byte[] getCalculatedAuthenticationBytes() {
        return this.mac.doFinal();
    }
}

