/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.crypto;

import me.forseth11.easybackup.dependencies.zip4j.crypto.Decrypter;
import me.forseth11.easybackup.dependencies.zip4j.crypto.engine.ZipCryptoEngine;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;

public class StandardDecrypter
implements Decrypter {
    private ZipCryptoEngine zipCryptoEngine = new ZipCryptoEngine();

    public StandardDecrypter(char[] cArray, long l2, long l3, byte[] byArray) {
        this.init(byArray, cArray, l3, l2);
    }

    @Override
    public int decryptData(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            throw new ZipException("one of the input parameters were null in standard decrypt data");
        }
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            int n4 = byArray[i2] & 0xFF;
            n4 = (n4 ^ this.zipCryptoEngine.decryptByte()) & 0xFF;
            this.zipCryptoEngine.updateKeys((byte)n4);
            byArray[i2] = (byte)n4;
        }
        return n3;
    }

    private void init(byte[] byArray, char[] cArray, long l2, long l3) {
        if (cArray == null || cArray.length <= 0) {
            throw new ZipException("Wrong password!", ZipException.Type.WRONG_PASSWORD);
        }
        this.zipCryptoEngine.initKeys(cArray);
        byte by2 = byArray[0];
        for (int i2 = 0; i2 < 12; ++i2) {
            byte by3;
            if (i2 + 1 == 12 && (by3 = (byte)(by2 ^ this.zipCryptoEngine.decryptByte())) != (byte)(l3 >> 24) && by3 != (byte)(l2 >> 8)) {
                throw new ZipException("Wrong password!", ZipException.Type.WRONG_PASSWORD);
            }
            this.zipCryptoEngine.updateKeys((byte)(by2 ^ this.zipCryptoEngine.decryptByte()));
            if (i2 + 1 == 12) continue;
            by2 = byArray[i2 + 1];
        }
    }
}

