/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.headers;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderSignature;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.NumberedSplitRandomAccessFile;
import me.forseth11.easybackup.dependencies.zip4j.model.AESExtraDataRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.AbstractFileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.CentralDirectory;
import me.forseth11.easybackup.dependencies.zip4j.model.DataDescriptor;
import me.forseth11.easybackup.dependencies.zip4j.model.DigitalSignature;
import me.forseth11.easybackup.dependencies.zip4j.model.EndOfCentralDirectoryRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.ExtraDataRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.LocalFileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip64EndOfCentralDirectoryLocator;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip64EndOfCentralDirectoryRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip64ExtendedInfo;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.AesKeyStrength;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.AesVersion;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionMethod;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.EncryptionMethod;
import me.forseth11.easybackup.dependencies.zip4j.util.BitUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.InternalZipConstants;
import me.forseth11.easybackup.dependencies.zip4j.util.RawIO;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class HeaderReader {
    private ZipModel zipModel;
    private RawIO rawIO = new RawIO();
    private byte[] intBuff = new byte[4];

    public ZipModel readAllHeaders(RandomAccessFile randomAccessFile, Zip4jConfig zip4jConfig) {
        if (randomAccessFile.length() < 22L) {
            throw new ZipException("Zip file size less than minimum expected zip file size. Probably not a zip file or a corrupted zip file");
        }
        this.zipModel = new ZipModel();
        try {
            this.zipModel.setEndOfCentralDirectoryRecord(this.readEndOfCentralDirectoryRecord(randomAccessFile, this.rawIO, zip4jConfig));
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (IOException iOException) {
            throw new ZipException("Zip headers not found. Probably not a zip file or a corrupted zip file", iOException);
        }
        if (this.zipModel.getEndOfCentralDirectoryRecord().getTotalNumberOfEntriesInCentralDirectory() == 0) {
            return this.zipModel;
        }
        this.zipModel.setZip64EndOfCentralDirectoryLocator(this.readZip64EndOfCentralDirectoryLocator(randomAccessFile, this.rawIO, this.zipModel.getEndOfCentralDirectoryRecord().getOffsetOfEndOfCentralDirectory()));
        if (this.zipModel.isZip64Format()) {
            this.zipModel.setZip64EndOfCentralDirectoryRecord(this.readZip64EndCentralDirRec(randomAccessFile, this.rawIO));
            if (this.zipModel.getZip64EndOfCentralDirectoryRecord() != null && this.zipModel.getZip64EndOfCentralDirectoryRecord().getNumberOfThisDisk() > 0) {
                this.zipModel.setSplitArchive(true);
            } else {
                this.zipModel.setSplitArchive(false);
            }
        }
        this.zipModel.setCentralDirectory(this.readCentralDirectory(randomAccessFile, this.rawIO, zip4jConfig.getCharset()));
        return this.zipModel;
    }

    private EndOfCentralDirectoryRecord readEndOfCentralDirectoryRecord(RandomAccessFile randomAccessFile, RawIO rawIO, Zip4jConfig zip4jConfig) {
        long l2 = randomAccessFile.length() - 22L;
        this.seekInCurrentPart(randomAccessFile, l2);
        int n2 = rawIO.readIntLittleEndian(randomAccessFile);
        if ((long)n2 != HeaderSignature.END_OF_CENTRAL_DIRECTORY.getValue()) {
            l2 = this.determineOffsetOfEndOfCentralDirectory(randomAccessFile, zip4jConfig.getBufferSize());
            randomAccessFile.seek(l2 + 4L);
        }
        EndOfCentralDirectoryRecord endOfCentralDirectoryRecord = new EndOfCentralDirectoryRecord();
        endOfCentralDirectoryRecord.setSignature(HeaderSignature.END_OF_CENTRAL_DIRECTORY);
        endOfCentralDirectoryRecord.setNumberOfThisDisk(rawIO.readShortLittleEndian(randomAccessFile));
        endOfCentralDirectoryRecord.setNumberOfThisDiskStartOfCentralDir(rawIO.readShortLittleEndian(randomAccessFile));
        endOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(rawIO.readShortLittleEndian(randomAccessFile));
        endOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectory(rawIO.readShortLittleEndian(randomAccessFile));
        endOfCentralDirectoryRecord.setSizeOfCentralDirectory(rawIO.readIntLittleEndian(randomAccessFile));
        endOfCentralDirectoryRecord.setOffsetOfEndOfCentralDirectory(l2);
        randomAccessFile.readFully(this.intBuff);
        endOfCentralDirectoryRecord.setOffsetOfStartOfCentralDirectory(rawIO.readLongLittleEndian(this.intBuff, 0));
        int n3 = rawIO.readShortLittleEndian(randomAccessFile);
        endOfCentralDirectoryRecord.setComment(this.readZipComment(randomAccessFile, n3, zip4jConfig.getCharset()));
        this.zipModel.setSplitArchive(endOfCentralDirectoryRecord.getNumberOfThisDisk() > 0);
        return endOfCentralDirectoryRecord;
    }

    private CentralDirectory readCentralDirectory(RandomAccessFile randomAccessFile, RawIO rawIO, Charset charset) {
        Object object;
        CentralDirectory centralDirectory = new CentralDirectory();
        ArrayList<FileHeader> arrayList = new ArrayList<FileHeader>();
        long l2 = HeaderUtil.getOffsetStartOfCentralDirectory(this.zipModel);
        long l3 = this.getNumberOfEntriesInCentralDirectory(this.zipModel);
        randomAccessFile.seek(l2);
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[4];
        int n2 = 0;
        while ((long)n2 < l3) {
            byte[] byArray3;
            object = new FileHeader();
            if ((long)rawIO.readIntLittleEndian(randomAccessFile) != HeaderSignature.CENTRAL_DIRECTORY.getValue()) {
                throw new ZipException("Expected central directory entry not found (#" + (n2 + 1) + ")");
            }
            ((ZipHeader)object).setSignature(HeaderSignature.CENTRAL_DIRECTORY);
            ((FileHeader)object).setVersionMadeBy(rawIO.readShortLittleEndian(randomAccessFile));
            ((AbstractFileHeader)object).setVersionNeededToExtract(rawIO.readShortLittleEndian(randomAccessFile));
            byte[] byArray4 = new byte[2];
            randomAccessFile.readFully(byArray4);
            ((AbstractFileHeader)object).setEncrypted(BitUtils.isBitSet(byArray4[0], 0));
            ((AbstractFileHeader)object).setDataDescriptorExists(BitUtils.isBitSet(byArray4[0], 3));
            ((AbstractFileHeader)object).setFileNameUTF8Encoded(BitUtils.isBitSet(byArray4[1], 3));
            ((AbstractFileHeader)object).setGeneralPurposeFlag((byte[])byArray4.clone());
            ((AbstractFileHeader)object).setCompressionMethod(CompressionMethod.getCompressionMethodFromCode(rawIO.readShortLittleEndian(randomAccessFile)));
            ((AbstractFileHeader)object).setLastModifiedTime(rawIO.readIntLittleEndian(randomAccessFile));
            randomAccessFile.readFully(byArray2);
            ((AbstractFileHeader)object).setCrc(rawIO.readLongLittleEndian(byArray2, 0));
            ((AbstractFileHeader)object).setCompressedSize(rawIO.readLongLittleEndian(randomAccessFile, 4));
            ((AbstractFileHeader)object).setUncompressedSize(rawIO.readLongLittleEndian(randomAccessFile, 4));
            int n3 = rawIO.readShortLittleEndian(randomAccessFile);
            ((AbstractFileHeader)object).setFileNameLength(n3);
            ((AbstractFileHeader)object).setExtraFieldLength(rawIO.readShortLittleEndian(randomAccessFile));
            int n4 = rawIO.readShortLittleEndian(randomAccessFile);
            ((FileHeader)object).setFileCommentLength(n4);
            ((FileHeader)object).setDiskNumberStart(rawIO.readShortLittleEndian(randomAccessFile));
            randomAccessFile.readFully(byArray);
            ((FileHeader)object).setInternalFileAttributes((byte[])byArray.clone());
            randomAccessFile.readFully(byArray2);
            ((FileHeader)object).setExternalFileAttributes((byte[])byArray2.clone());
            randomAccessFile.readFully(byArray2);
            ((FileHeader)object).setOffsetLocalHeader(rawIO.readLongLittleEndian(byArray2, 0));
            if (n3 > 0) {
                byArray3 = new byte[n3];
                randomAccessFile.readFully(byArray3);
                String string = HeaderUtil.decodeStringWithCharset(byArray3, ((AbstractFileHeader)object).isFileNameUTF8Encoded(), charset);
                if (string.contains(":\\")) {
                    string = string.substring(string.indexOf(":\\") + 2);
                }
                ((AbstractFileHeader)object).setFileName(string);
            } else {
                ((AbstractFileHeader)object).setFileName(null);
            }
            ((AbstractFileHeader)object).setDirectory(this.isDirectory(((FileHeader)object).getExternalFileAttributes(), ((AbstractFileHeader)object).getFileName()));
            this.readExtraDataRecords(randomAccessFile, (FileHeader)object);
            this.readZip64ExtendedInfo((FileHeader)object, rawIO);
            this.readAesExtraDataRecord((FileHeader)object, rawIO);
            if (n4 > 0) {
                byArray3 = new byte[n4];
                randomAccessFile.readFully(byArray3);
                ((FileHeader)object).setFileComment(HeaderUtil.decodeStringWithCharset(byArray3, ((AbstractFileHeader)object).isFileNameUTF8Encoded(), charset));
            }
            if (((AbstractFileHeader)object).isEncrypted()) {
                if (((AbstractFileHeader)object).getAesExtraDataRecord() != null) {
                    ((AbstractFileHeader)object).setEncryptionMethod(EncryptionMethod.AES);
                } else {
                    ((AbstractFileHeader)object).setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
                }
            }
            arrayList.add((FileHeader)object);
            ++n2;
        }
        centralDirectory.setFileHeaders(arrayList);
        DigitalSignature digitalSignature = new DigitalSignature();
        if ((long)rawIO.readIntLittleEndian(randomAccessFile) == HeaderSignature.DIGITAL_SIGNATURE.getValue()) {
            digitalSignature.setSignature(HeaderSignature.DIGITAL_SIGNATURE);
            digitalSignature.setSizeOfData(rawIO.readShortLittleEndian(randomAccessFile));
            if (digitalSignature.getSizeOfData() > 0) {
                object = new byte[digitalSignature.getSizeOfData()];
                randomAccessFile.readFully((byte[])object);
                digitalSignature.setSignatureData(new String((byte[])object));
            }
        }
        return centralDirectory;
    }

    private void readExtraDataRecords(RandomAccessFile randomAccessFile, FileHeader fileHeader) {
        int n2 = fileHeader.getExtraFieldLength();
        if (n2 <= 0) {
            return;
        }
        fileHeader.setExtraDataRecords(this.readExtraDataRecords(randomAccessFile, n2));
    }

    private void readExtraDataRecords(InputStream inputStream, LocalFileHeader localFileHeader) {
        int n2 = localFileHeader.getExtraFieldLength();
        if (n2 <= 0) {
            return;
        }
        localFileHeader.setExtraDataRecords(this.readExtraDataRecords(inputStream, n2));
    }

    private List<ExtraDataRecord> readExtraDataRecords(RandomAccessFile randomAccessFile, int n2) {
        if (n2 < 4) {
            if (n2 > 0) {
                randomAccessFile.skipBytes(n2);
            }
            return null;
        }
        byte[] byArray = new byte[n2];
        randomAccessFile.read(byArray);
        try {
            return this.parseExtraDataRecords(byArray, n2);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private List<ExtraDataRecord> readExtraDataRecords(InputStream inputStream, int n2) {
        if (n2 < 4) {
            if (n2 > 0) {
                inputStream.skip(n2);
            }
            return null;
        }
        byte[] byArray = new byte[n2];
        Zip4jUtil.readFully(inputStream, byArray);
        try {
            return this.parseExtraDataRecords(byArray, n2);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private List<ExtraDataRecord> parseExtraDataRecords(byte[] byArray, int n2) {
        int n3;
        ArrayList<ExtraDataRecord> arrayList = new ArrayList<ExtraDataRecord>();
        for (int i2 = 0; i2 < n2; i2 += n3) {
            ExtraDataRecord extraDataRecord = new ExtraDataRecord();
            int n4 = this.rawIO.readShortLittleEndian(byArray, i2);
            extraDataRecord.setHeader(n4);
            n3 = this.rawIO.readShortLittleEndian(byArray, i2 += 2);
            extraDataRecord.setSizeOfData(n3);
            i2 += 2;
            if (n3 > 0) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, i2, byArray2, 0, n3);
                extraDataRecord.setData(byArray2);
            }
            arrayList.add(extraDataRecord);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    private Zip64EndOfCentralDirectoryLocator readZip64EndOfCentralDirectoryLocator(RandomAccessFile randomAccessFile, RawIO rawIO, long l2) {
        Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator = new Zip64EndOfCentralDirectoryLocator();
        this.setFilePointerToReadZip64EndCentralDirLoc(randomAccessFile, l2);
        int n2 = rawIO.readIntLittleEndian(randomAccessFile);
        if ((long)n2 != HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_LOCATOR.getValue()) {
            this.zipModel.setZip64Format(false);
            return null;
        }
        this.zipModel.setZip64Format(true);
        zip64EndOfCentralDirectoryLocator.setSignature(HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_LOCATOR);
        zip64EndOfCentralDirectoryLocator.setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(rawIO.readIntLittleEndian(randomAccessFile));
        zip64EndOfCentralDirectoryLocator.setOffsetZip64EndOfCentralDirectoryRecord(rawIO.readLongLittleEndian(randomAccessFile));
        zip64EndOfCentralDirectoryLocator.setTotalNumberOfDiscs(rawIO.readIntLittleEndian(randomAccessFile));
        return zip64EndOfCentralDirectoryLocator;
    }

    private Zip64EndOfCentralDirectoryRecord readZip64EndCentralDirRec(RandomAccessFile randomAccessFile, RawIO rawIO) {
        if (this.zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
            throw new ZipException("invalid zip64 end of central directory locator");
        }
        long l2 = this.zipModel.getZip64EndOfCentralDirectoryLocator().getOffsetZip64EndOfCentralDirectoryRecord();
        if (l2 < 0L) {
            throw new ZipException("invalid offset for start of end of central directory record");
        }
        randomAccessFile.seek(l2);
        Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord = new Zip64EndOfCentralDirectoryRecord();
        int n2 = rawIO.readIntLittleEndian(randomAccessFile);
        if ((long)n2 != HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_RECORD.getValue()) {
            throw new ZipException("invalid signature for zip64 end of central directory record");
        }
        zip64EndOfCentralDirectoryRecord.setSignature(HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_RECORD);
        zip64EndOfCentralDirectoryRecord.setSizeOfZip64EndCentralDirectoryRecord(rawIO.readLongLittleEndian(randomAccessFile));
        zip64EndOfCentralDirectoryRecord.setVersionMadeBy(rawIO.readShortLittleEndian(randomAccessFile));
        zip64EndOfCentralDirectoryRecord.setVersionNeededToExtract(rawIO.readShortLittleEndian(randomAccessFile));
        zip64EndOfCentralDirectoryRecord.setNumberOfThisDisk(rawIO.readIntLittleEndian(randomAccessFile));
        zip64EndOfCentralDirectoryRecord.setNumberOfThisDiskStartOfCentralDirectory(rawIO.readIntLittleEndian(randomAccessFile));
        zip64EndOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(rawIO.readLongLittleEndian(randomAccessFile));
        zip64EndOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectory(rawIO.readLongLittleEndian(randomAccessFile));
        zip64EndOfCentralDirectoryRecord.setSizeOfCentralDirectory(rawIO.readLongLittleEndian(randomAccessFile));
        zip64EndOfCentralDirectoryRecord.setOffsetStartCentralDirectoryWRTStartDiskNumber(rawIO.readLongLittleEndian(randomAccessFile));
        long l3 = zip64EndOfCentralDirectoryRecord.getSizeOfZip64EndCentralDirectoryRecord() - 44L;
        if (l3 > 0L) {
            byte[] byArray = new byte[(int)l3];
            randomAccessFile.readFully(byArray);
            zip64EndOfCentralDirectoryRecord.setExtensibleDataSector(byArray);
        }
        return zip64EndOfCentralDirectoryRecord;
    }

    private void readZip64ExtendedInfo(FileHeader fileHeader, RawIO rawIO) {
        if (fileHeader.getExtraDataRecords() == null || fileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        Zip64ExtendedInfo zip64ExtendedInfo = this.readZip64ExtendedInfo(fileHeader.getExtraDataRecords(), rawIO, fileHeader.getUncompressedSize(), fileHeader.getCompressedSize(), fileHeader.getOffsetLocalHeader(), fileHeader.getDiskNumberStart());
        if (zip64ExtendedInfo == null) {
            return;
        }
        fileHeader.setZip64ExtendedInfo(zip64ExtendedInfo);
        if (zip64ExtendedInfo.getUncompressedSize() != -1L) {
            fileHeader.setUncompressedSize(zip64ExtendedInfo.getUncompressedSize());
        }
        if (zip64ExtendedInfo.getCompressedSize() != -1L) {
            fileHeader.setCompressedSize(zip64ExtendedInfo.getCompressedSize());
        }
        if (zip64ExtendedInfo.getOffsetLocalHeader() != -1L) {
            fileHeader.setOffsetLocalHeader(zip64ExtendedInfo.getOffsetLocalHeader());
        }
        if (zip64ExtendedInfo.getDiskNumberStart() != -1) {
            fileHeader.setDiskNumberStart(zip64ExtendedInfo.getDiskNumberStart());
        }
    }

    private void readZip64ExtendedInfo(LocalFileHeader localFileHeader, RawIO rawIO) {
        if (localFileHeader == null) {
            throw new ZipException("file header is null in reading Zip64 Extended Info");
        }
        if (localFileHeader.getExtraDataRecords() == null || localFileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        Zip64ExtendedInfo zip64ExtendedInfo = this.readZip64ExtendedInfo(localFileHeader.getExtraDataRecords(), rawIO, localFileHeader.getUncompressedSize(), localFileHeader.getCompressedSize(), 0L, 0);
        if (zip64ExtendedInfo == null) {
            return;
        }
        localFileHeader.setZip64ExtendedInfo(zip64ExtendedInfo);
        if (zip64ExtendedInfo.getUncompressedSize() != -1L) {
            localFileHeader.setUncompressedSize(zip64ExtendedInfo.getUncompressedSize());
        }
        if (zip64ExtendedInfo.getCompressedSize() != -1L) {
            localFileHeader.setCompressedSize(zip64ExtendedInfo.getCompressedSize());
        }
    }

    private Zip64ExtendedInfo readZip64ExtendedInfo(List<ExtraDataRecord> list, RawIO rawIO, long l2, long l3, long l4, int n2) {
        for (ExtraDataRecord extraDataRecord : list) {
            if (extraDataRecord == null || HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue() != extraDataRecord.getHeader()) continue;
            Zip64ExtendedInfo zip64ExtendedInfo = new Zip64ExtendedInfo();
            byte[] byArray = extraDataRecord.getData();
            if (extraDataRecord.getSizeOfData() <= 0) {
                return null;
            }
            int n3 = 0;
            if (n3 < extraDataRecord.getSizeOfData() && l2 == 0xFFFFFFFFL) {
                zip64ExtendedInfo.setUncompressedSize(rawIO.readLongLittleEndian(byArray, n3));
                n3 += 8;
            }
            if (n3 < extraDataRecord.getSizeOfData() && l3 == 0xFFFFFFFFL) {
                zip64ExtendedInfo.setCompressedSize(rawIO.readLongLittleEndian(byArray, n3));
                n3 += 8;
            }
            if (n3 < extraDataRecord.getSizeOfData() && l4 == 0xFFFFFFFFL) {
                zip64ExtendedInfo.setOffsetLocalHeader(rawIO.readLongLittleEndian(byArray, n3));
                n3 += 8;
            }
            if (n3 < extraDataRecord.getSizeOfData() && n2 == 65535) {
                zip64ExtendedInfo.setDiskNumberStart(rawIO.readIntLittleEndian(byArray, n3));
            }
            return zip64ExtendedInfo;
        }
        return null;
    }

    private void setFilePointerToReadZip64EndCentralDirLoc(RandomAccessFile randomAccessFile, long l2) {
        this.seekInCurrentPart(randomAccessFile, l2 - 4L - 8L - 4L - 4L);
    }

    public LocalFileHeader readLocalFileHeader(InputStream inputStream, Charset charset) {
        LocalFileHeader localFileHeader = new LocalFileHeader();
        byte[] byArray = new byte[4];
        int n2 = this.rawIO.readIntLittleEndian(inputStream);
        if ((long)n2 != HeaderSignature.LOCAL_FILE_HEADER.getValue()) {
            return null;
        }
        localFileHeader.setSignature(HeaderSignature.LOCAL_FILE_HEADER);
        localFileHeader.setVersionNeededToExtract(this.rawIO.readShortLittleEndian(inputStream));
        byte[] byArray2 = new byte[2];
        if (Zip4jUtil.readFully(inputStream, byArray2) != 2) {
            throw new ZipException("Could not read enough bytes for generalPurposeFlags");
        }
        localFileHeader.setEncrypted(BitUtils.isBitSet(byArray2[0], 0));
        localFileHeader.setDataDescriptorExists(BitUtils.isBitSet(byArray2[0], 3));
        localFileHeader.setFileNameUTF8Encoded(BitUtils.isBitSet(byArray2[1], 3));
        localFileHeader.setGeneralPurposeFlag((byte[])byArray2.clone());
        localFileHeader.setCompressionMethod(CompressionMethod.getCompressionMethodFromCode(this.rawIO.readShortLittleEndian(inputStream)));
        localFileHeader.setLastModifiedTime(this.rawIO.readIntLittleEndian(inputStream));
        Zip4jUtil.readFully(inputStream, byArray);
        localFileHeader.setCrc(this.rawIO.readLongLittleEndian(byArray, 0));
        localFileHeader.setCompressedSize(this.rawIO.readLongLittleEndian(inputStream, 4));
        localFileHeader.setUncompressedSize(this.rawIO.readLongLittleEndian(inputStream, 4));
        int n3 = this.rawIO.readShortLittleEndian(inputStream);
        localFileHeader.setFileNameLength(n3);
        localFileHeader.setExtraFieldLength(this.rawIO.readShortLittleEndian(inputStream));
        if (n3 > 0) {
            byte[] byArray3 = new byte[n3];
            Zip4jUtil.readFully(inputStream, byArray3);
            String string = HeaderUtil.decodeStringWithCharset(byArray3, localFileHeader.isFileNameUTF8Encoded(), charset);
            if (string == null) {
                throw new ZipException("file name is null, cannot assign file name to local file header");
            }
            if (string.contains(":" + System.getProperty("file.separator"))) {
                string = string.substring(string.indexOf(":" + System.getProperty("file.separator")) + 2);
            }
            localFileHeader.setFileName(string);
            localFileHeader.setDirectory(string.endsWith("/") || string.endsWith("\\"));
        } else {
            localFileHeader.setFileName(null);
        }
        this.readExtraDataRecords(inputStream, localFileHeader);
        this.readZip64ExtendedInfo(localFileHeader, this.rawIO);
        this.readAesExtraDataRecord(localFileHeader, this.rawIO);
        if (localFileHeader.isEncrypted() && localFileHeader.getEncryptionMethod() != EncryptionMethod.AES) {
            if (BitUtils.isBitSet(localFileHeader.getGeneralPurposeFlag()[0], 6)) {
                localFileHeader.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD_VARIANT_STRONG);
            } else {
                localFileHeader.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
            }
        }
        return localFileHeader;
    }

    public DataDescriptor readDataDescriptor(InputStream inputStream, boolean bl2) {
        DataDescriptor dataDescriptor = new DataDescriptor();
        byte[] byArray = new byte[4];
        Zip4jUtil.readFully(inputStream, byArray);
        long l2 = this.rawIO.readLongLittleEndian(byArray, 0);
        if (l2 == HeaderSignature.EXTRA_DATA_RECORD.getValue()) {
            dataDescriptor.setSignature(HeaderSignature.EXTRA_DATA_RECORD);
            Zip4jUtil.readFully(inputStream, byArray);
            dataDescriptor.setCrc(this.rawIO.readLongLittleEndian(byArray, 0));
        } else {
            dataDescriptor.setCrc(l2);
        }
        if (bl2) {
            dataDescriptor.setCompressedSize(this.rawIO.readLongLittleEndian(inputStream));
            dataDescriptor.setUncompressedSize(this.rawIO.readLongLittleEndian(inputStream));
        } else {
            dataDescriptor.setCompressedSize(this.rawIO.readIntLittleEndian(inputStream));
            dataDescriptor.setUncompressedSize(this.rawIO.readIntLittleEndian(inputStream));
        }
        return dataDescriptor;
    }

    private void readAesExtraDataRecord(FileHeader fileHeader, RawIO rawIO) {
        if (fileHeader.getExtraDataRecords() == null || fileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        AESExtraDataRecord aESExtraDataRecord = this.readAesExtraDataRecord(fileHeader.getExtraDataRecords(), rawIO);
        if (aESExtraDataRecord != null) {
            fileHeader.setAesExtraDataRecord(aESExtraDataRecord);
            fileHeader.setEncryptionMethod(EncryptionMethod.AES);
        }
    }

    private void readAesExtraDataRecord(LocalFileHeader localFileHeader, RawIO rawIO) {
        if (localFileHeader.getExtraDataRecords() == null || localFileHeader.getExtraDataRecords().size() <= 0) {
            return;
        }
        AESExtraDataRecord aESExtraDataRecord = this.readAesExtraDataRecord(localFileHeader.getExtraDataRecords(), rawIO);
        if (aESExtraDataRecord != null) {
            localFileHeader.setAesExtraDataRecord(aESExtraDataRecord);
            localFileHeader.setEncryptionMethod(EncryptionMethod.AES);
        }
    }

    private AESExtraDataRecord readAesExtraDataRecord(List<ExtraDataRecord> list, RawIO rawIO) {
        if (list == null) {
            return null;
        }
        for (ExtraDataRecord extraDataRecord : list) {
            if (extraDataRecord == null || extraDataRecord.getHeader() != HeaderSignature.AES_EXTRA_DATA_RECORD.getValue()) continue;
            if (extraDataRecord.getData() == null) {
                throw new ZipException("corrupt AES extra data records");
            }
            AESExtraDataRecord aESExtraDataRecord = new AESExtraDataRecord();
            aESExtraDataRecord.setSignature(HeaderSignature.AES_EXTRA_DATA_RECORD);
            aESExtraDataRecord.setDataSize(extraDataRecord.getSizeOfData());
            byte[] byArray = extraDataRecord.getData();
            aESExtraDataRecord.setAesVersion(AesVersion.getFromVersionNumber(rawIO.readShortLittleEndian(byArray, 0)));
            byte[] byArray2 = new byte[2];
            System.arraycopy(byArray, 2, byArray2, 0, 2);
            aESExtraDataRecord.setVendorID(new String(byArray2));
            aESExtraDataRecord.setAesKeyStrength(AesKeyStrength.getAesKeyStrengthFromRawCode(byArray[4] & 0xFF));
            aESExtraDataRecord.setCompressionMethod(CompressionMethod.getCompressionMethodFromCode(rawIO.readShortLittleEndian(byArray, 5)));
            return aESExtraDataRecord;
        }
        return null;
    }

    private long getNumberOfEntriesInCentralDirectory(ZipModel zipModel) {
        if (zipModel.isZip64Format()) {
            return zipModel.getZip64EndOfCentralDirectoryRecord().getTotalNumberOfEntriesInCentralDirectory();
        }
        return zipModel.getEndOfCentralDirectoryRecord().getTotalNumberOfEntriesInCentralDirectory();
    }

    private long determineOffsetOfEndOfCentralDirectory(RandomAccessFile randomAccessFile, int n2) {
        byte[] byArray = new byte[n2];
        long l2 = randomAccessFile.getFilePointer();
        do {
            int n3;
            long l3;
            if ((l3 = l2 - (long)(n3 = l2 > (long)n2 ? n2 : (int)l2) + 4L) == 4L) {
                l3 = 0L;
            }
            this.seekInCurrentPart(randomAccessFile, l3);
            randomAccessFile.read(byArray, 0, n3);
            l2 = l3;
            for (int i2 = 0; i2 < n3 - 3; ++i2) {
                if ((long)this.rawIO.readIntLittleEndian(byArray, i2) != HeaderSignature.END_OF_CENTRAL_DIRECTORY.getValue()) continue;
                return l2 + (long)i2;
            }
        } while (l2 > 0L);
        throw new ZipException("Zip headers not found. Probably not a zip file");
    }

    private void seekInCurrentPart(RandomAccessFile randomAccessFile, long l2) {
        if (randomAccessFile instanceof NumberedSplitRandomAccessFile) {
            ((NumberedSplitRandomAccessFile)randomAccessFile).seekInCurrentPart(l2);
        } else {
            randomAccessFile.seek(l2);
        }
    }

    private String readZipComment(RandomAccessFile randomAccessFile, int n2, Charset charset) {
        if (n2 <= 0) {
            return null;
        }
        try {
            byte[] byArray = new byte[n2];
            randomAccessFile.readFully(byArray);
            return HeaderUtil.decodeStringWithCharset(byArray, false, charset != null ? charset : InternalZipConstants.ZIP4J_DEFAULT_CHARSET);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isDirectory(byte[] byArray, String string) {
        if (byArray[0] != 0 && BitUtils.isBitSet(byArray[0], 4)) {
            return true;
        }
        if (byArray[3] != 0 && BitUtils.isBitSet(byArray[3], 6)) {
            return true;
        }
        return string != null && (string.endsWith("/") || string.endsWith("\\"));
    }
}

