/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.headers;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.util.InternalZipConstants;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class HeaderUtil {
    public static FileHeader getFileHeader(ZipModel zipModel, String string) {
        FileHeader fileHeader = HeaderUtil.getFileHeaderWithExactMatch(zipModel, string);
        if (fileHeader == null && (fileHeader = HeaderUtil.getFileHeaderWithExactMatch(zipModel, string = string.replaceAll("\\\\", "/"))) == null) {
            string = string.replaceAll("/", "\\\\");
            fileHeader = HeaderUtil.getFileHeaderWithExactMatch(zipModel, string);
        }
        return fileHeader;
    }

    public static String decodeStringWithCharset(byte[] byArray, boolean bl2, Charset charset) {
        if (charset != null) {
            return new String(byArray, charset);
        }
        if (bl2) {
            return new String(byArray, InternalZipConstants.CHARSET_UTF_8);
        }
        try {
            return new String(byArray, "Cp437");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    public static byte[] getBytesFromString(String string, Charset charset) {
        if (charset == null) {
            return string.getBytes(InternalZipConstants.ZIP4J_DEFAULT_CHARSET);
        }
        return string.getBytes(charset);
    }

    public static long getOffsetStartOfCentralDirectory(ZipModel zipModel) {
        if (zipModel.isZip64Format()) {
            return zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber();
        }
        return zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory();
    }

    public static List<FileHeader> getFileHeadersUnderDirectory(List<FileHeader> list, FileHeader fileHeader) {
        if (!fileHeader.isDirectory()) {
            return Collections.emptyList();
        }
        return list.stream().filter(fileHeader2 -> fileHeader2.getFileName().startsWith(fileHeader.getFileName())).collect(Collectors.toList());
    }

    public static long getTotalUncompressedSizeOfAllFileHeaders(List<FileHeader> list) {
        long l2 = 0L;
        for (FileHeader fileHeader : list) {
            if (fileHeader.getZip64ExtendedInfo() != null && fileHeader.getZip64ExtendedInfo().getUncompressedSize() > 0L) {
                l2 += fileHeader.getZip64ExtendedInfo().getUncompressedSize();
                continue;
            }
            l2 += fileHeader.getUncompressedSize();
        }
        return l2;
    }

    private static FileHeader getFileHeaderWithExactMatch(ZipModel zipModel, String string) {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot determine file header with exact match for fileName: " + string);
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("file name is null, cannot determine file header with exact match for fileName: " + string);
        }
        if (zipModel.getCentralDirectory() == null) {
            throw new ZipException("central directory is null, cannot determine file header with exact match for fileName: " + string);
        }
        if (zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException("file Headers are null, cannot determine file header with exact match for fileName: " + string);
        }
        if (zipModel.getCentralDirectory().getFileHeaders().size() == 0) {
            return null;
        }
        for (FileHeader fileHeader : zipModel.getCentralDirectory().getFileHeaders()) {
            String string2 = fileHeader.getFileName();
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(string2) || !string.equalsIgnoreCase(string2)) continue;
            return fileHeader;
        }
        return null;
    }
}

