/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.headers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderSignature;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.CountingOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.OutputStreamWithSplitZipSupport;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.SplitOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.AESExtraDataRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.ExtraDataRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.LocalFileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip64EndOfCentralDirectoryLocator;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip64EndOfCentralDirectoryRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.util.FileUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.RawIO;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public class HeaderWriter {
    private static final short ZIP64_EXTRA_DATA_RECORD_SIZE_LFH = 16;
    private static final short ZIP64_EXTRA_DATA_RECORD_SIZE_FH = 28;
    private static final short AES_EXTRA_DATA_RECORD_SIZE = 11;
    private RawIO rawIO = new RawIO();
    private byte[] longBuff = new byte[8];
    private byte[] intBuff = new byte[4];

    public void writeLocalFileHeader(ZipModel zipModel, LocalFileHeader localFileHeader, OutputStream outputStream, Charset charset) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            boolean bl2;
            this.rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)localFileHeader.getSignature().getValue());
            this.rawIO.writeShortLittleEndian(byteArrayOutputStream, localFileHeader.getVersionNeededToExtract());
            byteArrayOutputStream.write(localFileHeader.getGeneralPurposeFlag());
            this.rawIO.writeShortLittleEndian(byteArrayOutputStream, localFileHeader.getCompressionMethod().getCode());
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getLastModifiedTime());
            byteArrayOutputStream.write(this.longBuff, 0, 4);
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getCrc());
            byteArrayOutputStream.write(this.longBuff, 0, 4);
            boolean bl3 = bl2 = localFileHeader.getCompressedSize() >= 0xFFFFFFFFL || localFileHeader.getUncompressedSize() >= 0xFFFFFFFFL;
            if (bl2) {
                this.rawIO.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                zipModel.setZip64Format(true);
                localFileHeader.setWriteCompressedSizeInZip64ExtraRecord(true);
            } else {
                this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getCompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getUncompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                localFileHeader.setWriteCompressedSizeInZip64ExtraRecord(false);
            }
            byte[] byArray = new byte[]{};
            if (Zip4jUtil.isStringNotNullAndNotEmpty(localFileHeader.getFileName())) {
                byArray = HeaderUtil.getBytesFromString(localFileHeader.getFileName(), charset);
            }
            this.rawIO.writeShortLittleEndian(byteArrayOutputStream, byArray.length);
            int n2 = 0;
            if (bl2) {
                n2 += 20;
            }
            if (localFileHeader.getAesExtraDataRecord() != null) {
                n2 += 11;
            }
            this.rawIO.writeShortLittleEndian(byteArrayOutputStream, n2);
            if (byArray.length > 0) {
                byteArrayOutputStream.write(byArray);
            }
            if (bl2) {
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue());
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, 16);
                this.rawIO.writeLongLittleEndian(byteArrayOutputStream, localFileHeader.getUncompressedSize());
                this.rawIO.writeLongLittleEndian(byteArrayOutputStream, localFileHeader.getCompressedSize());
            }
            if (localFileHeader.getAesExtraDataRecord() != null) {
                AESExtraDataRecord aESExtraDataRecord = localFileHeader.getAesExtraDataRecord();
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)aESExtraDataRecord.getSignature().getValue());
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, aESExtraDataRecord.getDataSize());
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, aESExtraDataRecord.getAesVersion().getVersionNumber());
                byteArrayOutputStream.write(aESExtraDataRecord.getVendorID().getBytes());
                byte[] byArray2 = new byte[]{(byte)aESExtraDataRecord.getAesKeyStrength().getRawCode()};
                byteArrayOutputStream.write(byArray2);
                this.rawIO.writeShortLittleEndian(byteArrayOutputStream, aESExtraDataRecord.getCompressionMethod().getCode());
            }
            outputStream.write(byteArrayOutputStream.toByteArray());
        }
    }

    public void writeExtendedLocalHeader(LocalFileHeader localFileHeader, OutputStream outputStream) {
        if (localFileHeader == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot write extended local header");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)HeaderSignature.EXTRA_DATA_RECORD.getValue());
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getCrc());
            byteArrayOutputStream.write(this.longBuff, 0, 4);
            if (localFileHeader.isWriteCompressedSizeInZip64ExtraRecord()) {
                this.rawIO.writeLongLittleEndian(byteArrayOutputStream, localFileHeader.getCompressedSize());
                this.rawIO.writeLongLittleEndian(byteArrayOutputStream, localFileHeader.getUncompressedSize());
            } else {
                this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getCompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                this.rawIO.writeLongLittleEndian(this.longBuff, 0, localFileHeader.getUncompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
            }
            outputStream.write(byteArrayOutputStream.toByteArray());
        }
    }

    public void finalizeZipFile(ZipModel zipModel, OutputStream outputStream, Charset charset) {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot finalize zip file");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.processHeaderData(zipModel, outputStream);
            long l2 = this.getOffsetOfCentralDirectory(zipModel);
            this.writeCentralDirectory(zipModel, byteArrayOutputStream, this.rawIO, charset);
            int n2 = byteArrayOutputStream.size();
            if (zipModel.isZip64Format() || l2 >= 0xFFFFFFFFL || zipModel.getCentralDirectory().getFileHeaders().size() >= 65535) {
                if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
                    zipModel.setZip64EndOfCentralDirectoryRecord(new Zip64EndOfCentralDirectoryRecord());
                }
                if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
                    zipModel.setZip64EndOfCentralDirectoryLocator(new Zip64EndOfCentralDirectoryLocator());
                }
                zipModel.getZip64EndOfCentralDirectoryLocator().setOffsetZip64EndOfCentralDirectoryRecord(l2 + (long)n2);
                if (this.isSplitZipFile(outputStream)) {
                    int n3 = this.getCurrentSplitFileCounter(outputStream);
                    zipModel.getZip64EndOfCentralDirectoryLocator().setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(n3);
                    zipModel.getZip64EndOfCentralDirectoryLocator().setTotalNumberOfDiscs(n3 + 1);
                } else {
                    zipModel.getZip64EndOfCentralDirectoryLocator().setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(0);
                    zipModel.getZip64EndOfCentralDirectoryLocator().setTotalNumberOfDiscs(1);
                }
                Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord = this.buildZip64EndOfCentralDirectoryRecord(zipModel, n2, l2);
                zipModel.setZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryRecord);
                this.writeZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryRecord, byteArrayOutputStream, this.rawIO);
                this.writeZip64EndOfCentralDirectoryLocator(zipModel.getZip64EndOfCentralDirectoryLocator(), byteArrayOutputStream, this.rawIO);
            }
            this.writeEndOfCentralDirectoryRecord(zipModel, n2, l2, byteArrayOutputStream, this.rawIO, charset);
            this.writeZipHeaderBytes(zipModel, outputStream, byteArrayOutputStream.toByteArray(), charset);
        }
    }

    public void finalizeZipFileWithoutValidations(ZipModel zipModel, OutputStream outputStream, Charset charset) {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot finalize zip file without validations");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            long l2 = zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory();
            this.writeCentralDirectory(zipModel, byteArrayOutputStream, this.rawIO, charset);
            int n2 = byteArrayOutputStream.size();
            if (zipModel.isZip64Format() || l2 >= 0xFFFFFFFFL || zipModel.getCentralDirectory().getFileHeaders().size() >= 65535) {
                if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
                    zipModel.setZip64EndOfCentralDirectoryRecord(new Zip64EndOfCentralDirectoryRecord());
                }
                if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
                    zipModel.setZip64EndOfCentralDirectoryLocator(new Zip64EndOfCentralDirectoryLocator());
                }
                zipModel.getZip64EndOfCentralDirectoryLocator().setOffsetZip64EndOfCentralDirectoryRecord(l2 + (long)n2);
                Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord = this.buildZip64EndOfCentralDirectoryRecord(zipModel, n2, l2);
                zipModel.setZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryRecord);
                this.writeZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryRecord, byteArrayOutputStream, this.rawIO);
                this.writeZip64EndOfCentralDirectoryLocator(zipModel.getZip64EndOfCentralDirectoryLocator(), byteArrayOutputStream, this.rawIO);
            }
            this.writeEndOfCentralDirectoryRecord(zipModel, n2, l2, byteArrayOutputStream, this.rawIO, charset);
            this.writeZipHeaderBytes(zipModel, outputStream, byteArrayOutputStream.toByteArray(), charset);
        }
    }

    public void updateLocalFileHeader(FileHeader fileHeader, ZipModel zipModel, SplitOutputStream splitOutputStream) {
        SplitOutputStream splitOutputStream2;
        if (fileHeader == null || zipModel == null) {
            throw new ZipException("invalid input parameters, cannot update local file header");
        }
        boolean bl2 = false;
        if (fileHeader.getDiskNumberStart() != splitOutputStream.getCurrentSplitFileCounter()) {
            String string = zipModel.getZipFile().getParent();
            String string2 = FileUtils.getZipFileNameWithoutExtension(zipModel.getZipFile().getName());
            String string3 = string + System.getProperty("file.separator");
            string3 = fileHeader.getDiskNumberStart() < 9 ? string3 + string2 + ".z0" + (fileHeader.getDiskNumberStart() + 1) : string3 + string2 + ".z" + (fileHeader.getDiskNumberStart() + 1);
            splitOutputStream2 = new SplitOutputStream(new File(string3));
            bl2 = true;
        } else {
            splitOutputStream2 = splitOutputStream;
        }
        long l2 = splitOutputStream2.getFilePointer();
        splitOutputStream2.seek(fileHeader.getOffsetLocalHeader() + 14L);
        this.rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getCrc());
        splitOutputStream2.write(this.longBuff, 0, 4);
        this.updateFileSizesInLocalFileHeader(splitOutputStream2, fileHeader);
        if (bl2) {
            splitOutputStream2.close();
        } else {
            splitOutputStream.seek(l2);
        }
    }

    private void updateFileSizesInLocalFileHeader(SplitOutputStream splitOutputStream, FileHeader fileHeader) {
        if (fileHeader.getUncompressedSize() >= 0xFFFFFFFFL) {
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
            splitOutputStream.write(this.longBuff, 0, 4);
            splitOutputStream.write(this.longBuff, 0, 4);
            int n2 = 4 + fileHeader.getFileNameLength() + 2 + 2;
            if (splitOutputStream.skipBytes(n2) != n2) {
                throw new ZipException("Unable to skip " + n2 + " bytes to update LFH");
            }
            this.rawIO.writeLongLittleEndian(splitOutputStream, fileHeader.getUncompressedSize());
            this.rawIO.writeLongLittleEndian(splitOutputStream, fileHeader.getCompressedSize());
        } else {
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getCompressedSize());
            splitOutputStream.write(this.longBuff, 0, 4);
            this.rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getUncompressedSize());
            splitOutputStream.write(this.longBuff, 0, 4);
        }
    }

    private boolean isSplitZipFile(OutputStream outputStream) {
        if (outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)outputStream).isSplitZipFile();
        }
        if (outputStream instanceof CountingOutputStream) {
            return ((CountingOutputStream)outputStream).isSplitZipFile();
        }
        return false;
    }

    private int getCurrentSplitFileCounter(OutputStream outputStream) {
        if (outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)outputStream).getCurrentSplitFileCounter();
        }
        return ((CountingOutputStream)outputStream).getCurrentSplitFileCounter();
    }

    private void writeZipHeaderBytes(ZipModel zipModel, OutputStream outputStream, byte[] byArray, Charset charset) {
        if (byArray == null) {
            throw new ZipException("invalid buff to write as zip headers");
        }
        if (outputStream instanceof CountingOutputStream && ((CountingOutputStream)outputStream).checkBuffSizeAndStartNextSplitFile(byArray.length)) {
            this.finalizeZipFile(zipModel, outputStream, charset);
            return;
        }
        outputStream.write(byArray);
    }

    private void processHeaderData(ZipModel zipModel, OutputStream outputStream) {
        int n2 = 0;
        if (outputStream instanceof OutputStreamWithSplitZipSupport) {
            zipModel.getEndOfCentralDirectoryRecord().setOffsetOfStartOfCentralDirectory(((OutputStreamWithSplitZipSupport)((Object)outputStream)).getFilePointer());
            n2 = ((OutputStreamWithSplitZipSupport)((Object)outputStream)).getCurrentSplitFileCounter();
        }
        if (zipModel.isZip64Format()) {
            if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
                zipModel.setZip64EndOfCentralDirectoryRecord(new Zip64EndOfCentralDirectoryRecord());
            }
            if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
                zipModel.setZip64EndOfCentralDirectoryLocator(new Zip64EndOfCentralDirectoryLocator());
            }
            zipModel.getZip64EndOfCentralDirectoryRecord().setOffsetStartCentralDirectoryWRTStartDiskNumber(zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory());
            zipModel.getZip64EndOfCentralDirectoryLocator().setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(n2);
            zipModel.getZip64EndOfCentralDirectoryLocator().setTotalNumberOfDiscs(n2 + 1);
        }
        zipModel.getEndOfCentralDirectoryRecord().setNumberOfThisDisk(n2);
        zipModel.getEndOfCentralDirectoryRecord().setNumberOfThisDiskStartOfCentralDir(n2);
    }

    private void writeCentralDirectory(ZipModel zipModel, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO, Charset charset) {
        if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null || zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return;
        }
        for (FileHeader fileHeader : zipModel.getCentralDirectory().getFileHeaders()) {
            this.writeFileHeader(zipModel, fileHeader, byteArrayOutputStream, rawIO, charset);
        }
    }

    private void writeFileHeader(ZipModel zipModel, FileHeader fileHeader, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO, Charset charset) {
        if (fileHeader == null) {
            throw new ZipException("input parameters is null, cannot write local file header");
        }
        try {
            byte[] byArray = new byte[]{0, 0};
            boolean bl2 = this.isZip64Entry(fileHeader);
            rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)fileHeader.getSignature().getValue());
            rawIO.writeShortLittleEndian(byteArrayOutputStream, fileHeader.getVersionMadeBy());
            rawIO.writeShortLittleEndian(byteArrayOutputStream, fileHeader.getVersionNeededToExtract());
            byteArrayOutputStream.write(fileHeader.getGeneralPurposeFlag());
            rawIO.writeShortLittleEndian(byteArrayOutputStream, fileHeader.getCompressionMethod().getCode());
            rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getLastModifiedTime());
            byteArrayOutputStream.write(this.longBuff, 0, 4);
            rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getCrc());
            byteArrayOutputStream.write(this.longBuff, 0, 4);
            if (bl2) {
                rawIO.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                zipModel.setZip64Format(true);
            } else {
                rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getCompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
                rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getUncompressedSize());
                byteArrayOutputStream.write(this.longBuff, 0, 4);
            }
            byte[] byArray2 = new byte[]{};
            if (Zip4jUtil.isStringNotNullAndNotEmpty(fileHeader.getFileName())) {
                byArray2 = HeaderUtil.getBytesFromString(fileHeader.getFileName(), charset);
            }
            rawIO.writeShortLittleEndian(byteArrayOutputStream, byArray2.length);
            byte[] byArray3 = new byte[4];
            if (bl2) {
                rawIO.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
                System.arraycopy(this.longBuff, 0, byArray3, 0, 4);
            } else {
                rawIO.writeLongLittleEndian(this.longBuff, 0, fileHeader.getOffsetLocalHeader());
                System.arraycopy(this.longBuff, 0, byArray3, 0, 4);
            }
            int n2 = this.calculateExtraDataRecordsSize(fileHeader, bl2);
            rawIO.writeShortLittleEndian(byteArrayOutputStream, n2);
            String string = fileHeader.getFileComment();
            byte[] byArray4 = new byte[]{};
            if (Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
                byArray4 = HeaderUtil.getBytesFromString(string, charset);
            }
            rawIO.writeShortLittleEndian(byteArrayOutputStream, byArray4.length);
            if (bl2) {
                rawIO.writeIntLittleEndian(this.intBuff, 0, 65535);
                byteArrayOutputStream.write(this.intBuff, 0, 2);
            } else {
                rawIO.writeShortLittleEndian(byteArrayOutputStream, fileHeader.getDiskNumberStart());
            }
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(fileHeader.getExternalFileAttributes());
            byteArrayOutputStream.write(byArray3);
            if (byArray2.length > 0) {
                byteArrayOutputStream.write(byArray2);
            }
            if (bl2) {
                zipModel.setZip64Format(true);
                rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue());
                rawIO.writeShortLittleEndian(byteArrayOutputStream, 28);
                rawIO.writeLongLittleEndian(byteArrayOutputStream, fileHeader.getUncompressedSize());
                rawIO.writeLongLittleEndian(byteArrayOutputStream, fileHeader.getCompressedSize());
                rawIO.writeLongLittleEndian(byteArrayOutputStream, fileHeader.getOffsetLocalHeader());
                rawIO.writeIntLittleEndian(byteArrayOutputStream, fileHeader.getDiskNumberStart());
            }
            if (fileHeader.getAesExtraDataRecord() != null) {
                AESExtraDataRecord aESExtraDataRecord = fileHeader.getAesExtraDataRecord();
                rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)aESExtraDataRecord.getSignature().getValue());
                rawIO.writeShortLittleEndian(byteArrayOutputStream, aESExtraDataRecord.getDataSize());
                rawIO.writeShortLittleEndian(byteArrayOutputStream, aESExtraDataRecord.getAesVersion().getVersionNumber());
                byteArrayOutputStream.write(aESExtraDataRecord.getVendorID().getBytes());
                byte[] byArray5 = new byte[]{(byte)aESExtraDataRecord.getAesKeyStrength().getRawCode()};
                byteArrayOutputStream.write(byArray5);
                rawIO.writeShortLittleEndian(byteArrayOutputStream, aESExtraDataRecord.getCompressionMethod().getCode());
            }
            this.writeRemainingExtraDataRecordsIfPresent(fileHeader, byteArrayOutputStream);
            if (byArray4.length > 0) {
                byteArrayOutputStream.write(byArray4);
            }
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private int calculateExtraDataRecordsSize(FileHeader fileHeader, boolean bl2) {
        int n2 = 0;
        if (bl2) {
            n2 += 32;
        }
        if (fileHeader.getAesExtraDataRecord() != null) {
            n2 += 11;
        }
        if (fileHeader.getExtraDataRecords() != null) {
            for (ExtraDataRecord extraDataRecord : fileHeader.getExtraDataRecords()) {
                if (extraDataRecord.getHeader() == HeaderSignature.AES_EXTRA_DATA_RECORD.getValue() || extraDataRecord.getHeader() == HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue()) continue;
                n2 += 4 + extraDataRecord.getSizeOfData();
            }
        }
        return n2;
    }

    private void writeRemainingExtraDataRecordsIfPresent(FileHeader fileHeader, OutputStream outputStream) {
        if (fileHeader.getExtraDataRecords() == null || fileHeader.getExtraDataRecords().size() == 0) {
            return;
        }
        for (ExtraDataRecord extraDataRecord : fileHeader.getExtraDataRecords()) {
            if (extraDataRecord.getHeader() == HeaderSignature.AES_EXTRA_DATA_RECORD.getValue() || extraDataRecord.getHeader() == HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue()) continue;
            this.rawIO.writeShortLittleEndian(outputStream, (int)extraDataRecord.getHeader());
            this.rawIO.writeShortLittleEndian(outputStream, extraDataRecord.getSizeOfData());
            if (extraDataRecord.getSizeOfData() <= 0 || extraDataRecord.getData() == null) continue;
            outputStream.write(extraDataRecord.getData());
        }
    }

    private void writeZip64EndOfCentralDirectoryRecord(Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO) {
        rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)zip64EndOfCentralDirectoryRecord.getSignature().getValue());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getSizeOfZip64EndCentralDirectoryRecord());
        rawIO.writeShortLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getVersionMadeBy());
        rawIO.writeShortLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getVersionNeededToExtract());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getNumberOfThisDisk());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getNumberOfThisDiskStartOfCentralDirectory());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getTotalNumberOfEntriesInCentralDirectoryOnThisDisk());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getTotalNumberOfEntriesInCentralDirectory());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getSizeOfCentralDirectory());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getOffsetStartCentralDirectoryWRTStartDiskNumber());
    }

    private void writeZip64EndOfCentralDirectoryLocator(Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO) {
        rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_LOCATOR.getValue());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryLocator.getNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryLocator.getOffsetZip64EndOfCentralDirectoryRecord());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryLocator.getTotalNumberOfDiscs());
    }

    private void writeEndOfCentralDirectoryRecord(ZipModel zipModel, int n2, long l2, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO, Charset charset) {
        long l3;
        byte[] byArray = new byte[8];
        rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)HeaderSignature.END_OF_CENTRAL_DIRECTORY.getValue());
        rawIO.writeShortLittleEndian(byteArrayOutputStream, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        rawIO.writeShortLittleEndian(byteArrayOutputStream, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDiskStartOfCentralDir());
        long l4 = l3 = (long)zipModel.getCentralDirectory().getFileHeaders().size();
        if (zipModel.isSplitArchive()) {
            l4 = this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        }
        if (l4 > 65535L) {
            l4 = 65535L;
        }
        rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)l4);
        if (l3 > 65535L) {
            l3 = 65535L;
        }
        rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)l3);
        rawIO.writeIntLittleEndian(byteArrayOutputStream, n2);
        if (l2 > 0xFFFFFFFFL) {
            rawIO.writeLongLittleEndian(byArray, 0, 0xFFFFFFFFL);
            byteArrayOutputStream.write(byArray, 0, 4);
        } else {
            rawIO.writeLongLittleEndian(byArray, 0, l2);
            byteArrayOutputStream.write(byArray, 0, 4);
        }
        String string = zipModel.getEndOfCentralDirectoryRecord().getComment();
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            byte[] byArray2 = HeaderUtil.getBytesFromString(string, charset);
            rawIO.writeShortLittleEndian(byteArrayOutputStream, byArray2.length);
            byteArrayOutputStream.write(byArray2);
        } else {
            rawIO.writeShortLittleEndian(byteArrayOutputStream, 0);
        }
    }

    private long countNumberOfFileHeaderEntriesOnDisk(List<FileHeader> list, int n2) {
        if (list == null) {
            throw new ZipException("file headers are null, cannot calculate number of entries on this disk");
        }
        int n3 = 0;
        for (FileHeader fileHeader : list) {
            if (fileHeader.getDiskNumberStart() != n2) continue;
            ++n3;
        }
        return n3;
    }

    private boolean isZip64Entry(FileHeader fileHeader) {
        return fileHeader.getCompressedSize() >= 0xFFFFFFFFL || fileHeader.getUncompressedSize() >= 0xFFFFFFFFL || fileHeader.getOffsetLocalHeader() >= 0xFFFFFFFFL || fileHeader.getDiskNumberStart() >= 65535;
    }

    private long getOffsetOfCentralDirectory(ZipModel zipModel) {
        if (zipModel.isZip64Format() && zipModel.getZip64EndOfCentralDirectoryRecord() != null && zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber() != -1L) {
            return zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber();
        }
        return zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory();
    }

    private Zip64EndOfCentralDirectoryRecord buildZip64EndOfCentralDirectoryRecord(ZipModel zipModel, int n2, long l2) {
        long l3;
        Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord = new Zip64EndOfCentralDirectoryRecord();
        zip64EndOfCentralDirectoryRecord.setSignature(HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_RECORD);
        zip64EndOfCentralDirectoryRecord.setSizeOfZip64EndCentralDirectoryRecord(44L);
        if (zipModel.getCentralDirectory() != null && zipModel.getCentralDirectory().getFileHeaders() != null && zipModel.getCentralDirectory().getFileHeaders().size() > 0) {
            FileHeader fileHeader = zipModel.getCentralDirectory().getFileHeaders().get(0);
            zip64EndOfCentralDirectoryRecord.setVersionMadeBy(fileHeader.getVersionMadeBy());
            zip64EndOfCentralDirectoryRecord.setVersionNeededToExtract(fileHeader.getVersionNeededToExtract());
        }
        zip64EndOfCentralDirectoryRecord.setNumberOfThisDisk(zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        zip64EndOfCentralDirectoryRecord.setNumberOfThisDiskStartOfCentralDirectory(zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDiskStartOfCentralDir());
        long l4 = l3 = (long)zipModel.getCentralDirectory().getFileHeaders().size();
        if (zipModel.isSplitArchive()) {
            l4 = this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        }
        zip64EndOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(l4);
        zip64EndOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectory(l3);
        zip64EndOfCentralDirectoryRecord.setSizeOfCentralDirectory(n2);
        zip64EndOfCentralDirectoryRecord.setOffsetStartCentralDirectoryWRTStartDiskNumber(l2);
        return zip64EndOfCentralDirectoryRecord;
    }
}

