/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.inputstream;

import java.io.IOException;
import java.io.InputStream;

class ZipEntryInputStream
extends InputStream {
    private static final int MAX_RAW_READ_FULLY_RETRY_ATTEMPTS = 15;
    private InputStream inputStream;
    private long numberOfBytesRead = 0L;
    private byte[] singleByteArray = new byte[1];
    private long compressedSize;

    public ZipEntryInputStream(InputStream inputStream, long l2) {
        this.inputStream = inputStream;
        this.compressedSize = l2;
    }

    @Override
    public int read() {
        int n2 = this.read(this.singleByteArray);
        if (n2 == -1) {
            return -1;
        }
        return this.singleByteArray[0];
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (this.compressedSize != -1L) {
            if (this.numberOfBytesRead >= this.compressedSize) {
                return -1;
            }
            if ((long)n3 > this.compressedSize - this.numberOfBytesRead) {
                n3 = (int)(this.compressedSize - this.numberOfBytesRead);
            }
        }
        if ((n4 = this.inputStream.read(byArray, n2, n3)) > 0) {
            this.numberOfBytesRead += (long)n4;
        }
        return n4;
    }

    public int readRawFully(byte[] byArray) {
        int n2 = this.inputStream.read(byArray);
        if (n2 != byArray.length && (n2 = this.readUntilBufferIsFull(byArray, n2)) != byArray.length) {
            throw new IOException("Cannot read fully into byte buffer");
        }
        return n2;
    }

    private int readUntilBufferIsFull(byte[] byArray, int n2) {
        int n3 = byArray.length - n2;
        int n4 = 0;
        for (int i2 = 0; n2 < byArray.length && n4 != -1 && i2 < 15; ++i2) {
            if ((n4 += this.inputStream.read(byArray, n2, n3)) <= 0) continue;
            n2 += n4;
            n3 -= n4;
        }
        return n2;
    }

    @Override
    public void close() {
        this.inputStream.close();
    }

    public long getNumberOfBytesRead() {
        return this.numberOfBytesRead;
    }
}

