/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.outputstream;

import java.util.zip.Deflater;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.CipherOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.CompressedOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionLevel;

class DeflaterOutputStream
extends CompressedOutputStream {
    private byte[] buff;
    protected Deflater deflater;

    public DeflaterOutputStream(CipherOutputStream cipherOutputStream, CompressionLevel compressionLevel, int n2) {
        super(cipherOutputStream);
        this.deflater = new Deflater(compressionLevel.getLevel(), true);
        this.buff = new byte[n2];
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.deflater.setInput(byArray, n2, n3);
        while (!this.deflater.needsInput()) {
            this.deflate();
        }
    }

    private void deflate() {
        int n2 = this.deflater.deflate(this.buff, 0, this.buff.length);
        if (n2 > 0) {
            super.write(this.buff, 0, n2);
        }
    }

    @Override
    public void closeEntry() {
        if (!this.deflater.finished()) {
            this.deflater.finish();
            while (!this.deflater.finished()) {
                this.deflate();
            }
        }
        this.deflater.end();
        super.closeEntry();
    }
}

