/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.io.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.FileHeaderFactory;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderSignature;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderWriter;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.AesCipherOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.CipherOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.CompressedOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.CountingOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.DeflaterOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.NoCipherOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.StoreOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.ZipEntryOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.ZipStandardCipherOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.LocalFileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipParameters;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.AesVersion;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionMethod;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.EncryptionMethod;
import me.forseth11.easybackup.dependencies.zip4j.util.RawIO;

public class ZipOutputStream
extends OutputStream {
    private CountingOutputStream countingOutputStream;
    private char[] password;
    private ZipModel zipModel;
    private CompressedOutputStream compressedOutputStream;
    private FileHeader fileHeader;
    private LocalFileHeader localFileHeader;
    private FileHeaderFactory fileHeaderFactory = new FileHeaderFactory();
    private HeaderWriter headerWriter = new HeaderWriter();
    private CRC32 crc32 = new CRC32();
    private RawIO rawIO = new RawIO();
    private long uncompressedSizeForThisEntry = 0L;
    private Zip4jConfig zip4jConfig;
    private boolean streamClosed;

    public ZipOutputStream(OutputStream outputStream) {
        this(outputStream, null, null);
    }

    public ZipOutputStream(OutputStream outputStream, Charset charset) {
        this(outputStream, null, charset);
    }

    public ZipOutputStream(OutputStream outputStream, char[] cArray) {
        this(outputStream, cArray, null);
    }

    public ZipOutputStream(OutputStream outputStream, char[] cArray, Charset charset) {
        this(outputStream, cArray, new Zip4jConfig(charset, 4096), new ZipModel());
    }

    public ZipOutputStream(OutputStream outputStream, char[] cArray, Zip4jConfig zip4jConfig, ZipModel zipModel) {
        if (zip4jConfig.getBufferSize() < 512) {
            throw new IllegalArgumentException("Buffer size cannot be less than 512 bytes");
        }
        this.countingOutputStream = new CountingOutputStream(outputStream);
        this.password = cArray;
        this.zip4jConfig = zip4jConfig;
        this.zipModel = this.initializeZipModel(zipModel, this.countingOutputStream);
        this.streamClosed = false;
        this.writeSplitZipHeaderIfApplicable();
    }

    public void putNextEntry(ZipParameters zipParameters) {
        this.verifyZipParameters(zipParameters);
        this.initializeAndWriteFileHeader(zipParameters);
        this.compressedOutputStream = this.initializeCompressedOutputStream(zipParameters);
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)n2});
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.ensureStreamOpen();
        this.crc32.update(byArray, n2, n3);
        this.compressedOutputStream.write(byArray, n2, n3);
        this.uncompressedSizeForThisEntry += (long)n3;
    }

    public FileHeader closeEntry() {
        this.compressedOutputStream.closeEntry();
        long l2 = this.compressedOutputStream.getCompressedSize();
        this.fileHeader.setCompressedSize(l2);
        this.localFileHeader.setCompressedSize(l2);
        this.fileHeader.setUncompressedSize(this.uncompressedSizeForThisEntry);
        this.localFileHeader.setUncompressedSize(this.uncompressedSizeForThisEntry);
        if (this.writeCrc(this.fileHeader)) {
            this.fileHeader.setCrc(this.crc32.getValue());
            this.localFileHeader.setCrc(this.crc32.getValue());
        }
        this.zipModel.getLocalFileHeaders().add(this.localFileHeader);
        this.zipModel.getCentralDirectory().getFileHeaders().add(this.fileHeader);
        if (this.localFileHeader.isDataDescriptorExists()) {
            this.headerWriter.writeExtendedLocalHeader(this.localFileHeader, this.countingOutputStream);
        }
        this.reset();
        return this.fileHeader;
    }

    @Override
    public void close() {
        this.zipModel.getEndOfCentralDirectoryRecord().setOffsetOfStartOfCentralDirectory(this.countingOutputStream.getNumberOfBytesWritten());
        this.headerWriter.finalizeZipFile(this.zipModel, this.countingOutputStream, this.zip4jConfig.getCharset());
        this.countingOutputStream.close();
        this.streamClosed = true;
    }

    public void setComment(String string) {
        this.ensureStreamOpen();
        this.zipModel.getEndOfCentralDirectoryRecord().setComment(string);
    }

    private void ensureStreamOpen() {
        if (this.streamClosed) {
            throw new IOException("Stream is closed");
        }
    }

    private ZipModel initializeZipModel(ZipModel zipModel, CountingOutputStream countingOutputStream) {
        if (zipModel == null) {
            zipModel = new ZipModel();
        }
        if (countingOutputStream.isSplitZipFile()) {
            zipModel.setSplitArchive(true);
            zipModel.setSplitLength(countingOutputStream.getSplitLength());
        }
        return zipModel;
    }

    private void initializeAndWriteFileHeader(ZipParameters zipParameters) {
        this.fileHeader = this.fileHeaderFactory.generateFileHeader(zipParameters, this.countingOutputStream.isSplitZipFile(), this.countingOutputStream.getCurrentSplitFileCounter(), this.zip4jConfig.getCharset(), this.rawIO);
        this.fileHeader.setOffsetLocalHeader(this.countingOutputStream.getOffsetForNextEntry());
        this.localFileHeader = this.fileHeaderFactory.generateLocalFileHeader(this.fileHeader);
        this.headerWriter.writeLocalFileHeader(this.zipModel, this.localFileHeader, this.countingOutputStream, this.zip4jConfig.getCharset());
    }

    private void reset() {
        this.uncompressedSizeForThisEntry = 0L;
        this.crc32.reset();
        this.compressedOutputStream.close();
    }

    private void writeSplitZipHeaderIfApplicable() {
        if (!this.countingOutputStream.isSplitZipFile()) {
            return;
        }
        this.rawIO.writeIntLittleEndian(this.countingOutputStream, (int)HeaderSignature.SPLIT_ZIP.getValue());
    }

    private CompressedOutputStream initializeCompressedOutputStream(ZipParameters zipParameters) {
        ZipEntryOutputStream zipEntryOutputStream = new ZipEntryOutputStream(this.countingOutputStream);
        CipherOutputStream cipherOutputStream = this.initializeCipherOutputStream(zipEntryOutputStream, zipParameters);
        return this.initializeCompressedOutputStream(cipherOutputStream, zipParameters);
    }

    private CipherOutputStream initializeCipherOutputStream(ZipEntryOutputStream zipEntryOutputStream, ZipParameters zipParameters) {
        if (!zipParameters.isEncryptFiles()) {
            return new NoCipherOutputStream(zipEntryOutputStream, zipParameters, null);
        }
        if (this.password == null || this.password.length == 0) {
            throw new ZipException("password not set");
        }
        if (zipParameters.getEncryptionMethod() == EncryptionMethod.AES) {
            return new AesCipherOutputStream(zipEntryOutputStream, zipParameters, this.password);
        }
        if (zipParameters.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD) {
            return new ZipStandardCipherOutputStream(zipEntryOutputStream, zipParameters, this.password);
        }
        if (zipParameters.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD_VARIANT_STRONG) {
            throw new ZipException((Object)((Object)EncryptionMethod.ZIP_STANDARD_VARIANT_STRONG) + " encryption method is not supported");
        }
        throw new ZipException("Invalid encryption method");
    }

    private CompressedOutputStream initializeCompressedOutputStream(CipherOutputStream cipherOutputStream, ZipParameters zipParameters) {
        if (zipParameters.getCompressionMethod() == CompressionMethod.DEFLATE) {
            return new DeflaterOutputStream(cipherOutputStream, zipParameters.getCompressionLevel(), this.zip4jConfig.getBufferSize());
        }
        return new StoreOutputStream(cipherOutputStream);
    }

    private void verifyZipParameters(ZipParameters zipParameters) {
        if (zipParameters.getCompressionMethod() == CompressionMethod.STORE && zipParameters.getEntrySize() < 0L && !this.isEntryDirectory(zipParameters.getFileNameInZip()) && zipParameters.isWriteExtendedLocalFileHeader()) {
            throw new IllegalArgumentException("uncompressed size should be set for zip entries of compression type store");
        }
    }

    private boolean writeCrc(FileHeader fileHeader) {
        boolean bl2;
        boolean bl3 = bl2 = fileHeader.isEncrypted() && fileHeader.getEncryptionMethod().equals((Object)EncryptionMethod.AES);
        if (!bl2) {
            return true;
        }
        return fileHeader.getAesExtraDataRecord().getAesVersion().equals((Object)AesVersion.ONE);
    }

    private boolean isEntryDirectory(String string) {
        return string.endsWith("/") || string.endsWith("\\");
    }
}

