/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderWriter;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.SplitOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.ZipOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipParameters;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionMethod;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.EncryptionMethod;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AsyncZipTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.RemoveFilesFromZipTask;
import me.forseth11.easybackup.dependencies.zip4j.util.BitUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.CrcUtil;
import me.forseth11.easybackup.dependencies.zip4j.util.FileUtils;
import me.forseth11.easybackup.dependencies.zip4j.util.Zip4jUtil;

public abstract class AbstractAddFileToZipTask<T>
extends AsyncZipTask<T> {
    private ZipModel zipModel;
    private char[] password;
    private HeaderWriter headerWriter;

    AbstractAddFileToZipTask(ZipModel zipModel, char[] cArray, HeaderWriter headerWriter, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel;
        this.password = cArray;
        this.headerWriter = headerWriter;
    }

    void addFilesToZip(List<File> list, ProgressMonitor progressMonitor, ZipParameters zipParameters, Zip4jConfig zip4jConfig) {
        FileUtils.assertFilesExist(list, zipParameters.getSymbolicLinkAction());
        byte[] byArray = new byte[zip4jConfig.getBufferSize()];
        List<File> list2 = this.removeFilesIfExists(list, zipParameters, progressMonitor, zip4jConfig);
        try (SplitOutputStream splitOutputStream = new SplitOutputStream(this.zipModel.getZipFile(), this.zipModel.getSplitLength());
             ZipOutputStream zipOutputStream = this.initializeOutputStream(splitOutputStream, zip4jConfig);){
            for (File file : list2) {
                this.verifyIfTaskIsCancelled();
                ZipParameters zipParameters2 = this.cloneAndAdjustZipParameters(zipParameters, file, progressMonitor);
                progressMonitor.setFileName(file.getAbsolutePath());
                if (FileUtils.isSymbolicLink(file) && this.addSymlink(zipParameters2)) {
                    this.addSymlinkToZip(file, zipOutputStream, zipParameters2, splitOutputStream);
                    if (ZipParameters.SymbolicLinkAction.INCLUDE_LINK_ONLY.equals((Object)zipParameters2.getSymbolicLinkAction())) continue;
                }
                this.addFileToZip(file, zipOutputStream, zipParameters2, splitOutputStream, progressMonitor, byArray);
            }
        }
    }

    private void addSymlinkToZip(File file, ZipOutputStream zipOutputStream, ZipParameters zipParameters, SplitOutputStream splitOutputStream) {
        ZipParameters zipParameters2 = new ZipParameters(zipParameters);
        zipParameters2.setFileNameInZip(this.replaceFileNameInZip(zipParameters.getFileNameInZip(), file.getName()));
        zipParameters2.setEncryptFiles(false);
        zipParameters2.setCompressionMethod(CompressionMethod.STORE);
        zipOutputStream.putNextEntry(zipParameters2);
        String string = FileUtils.readSymbolicLink(file);
        zipOutputStream.write(string.getBytes());
        this.closeEntry(zipOutputStream, splitOutputStream, file, true);
    }

    private void addFileToZip(File file, ZipOutputStream zipOutputStream, ZipParameters zipParameters, SplitOutputStream splitOutputStream, ProgressMonitor progressMonitor, byte[] byArray) {
        zipOutputStream.putNextEntry(zipParameters);
        if (file.exists() && !file.isDirectory()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                int n2;
                while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n2);
                    progressMonitor.updateWorkCompleted(n2);
                    this.verifyIfTaskIsCancelled();
                }
            }
        }
        this.closeEntry(zipOutputStream, splitOutputStream, file, false);
    }

    private void closeEntry(ZipOutputStream zipOutputStream, SplitOutputStream splitOutputStream, File file, boolean bl2) {
        FileHeader fileHeader = zipOutputStream.closeEntry();
        byte[] byArray = FileUtils.getFileAttributes(file);
        if (!bl2) {
            byArray[3] = BitUtils.unsetBit(byArray[3], 5);
        }
        fileHeader.setExternalFileAttributes(byArray);
        this.updateLocalFileHeader(fileHeader, splitOutputStream);
    }

    long calculateWorkForFiles(List<File> list, ZipParameters zipParameters) {
        long l2 = 0L;
        for (File file : list) {
            if (!file.exists()) continue;
            l2 = zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD ? (l2 += file.length() * 2L) : (l2 += file.length());
            String string = FileUtils.getRelativeFileName(file, zipParameters);
            FileHeader fileHeader = HeaderUtil.getFileHeader(this.getZipModel(), string);
            if (fileHeader == null) continue;
            l2 += this.getZipModel().getZipFile().length() - fileHeader.getCompressedSize();
        }
        return l2;
    }

    ZipOutputStream initializeOutputStream(SplitOutputStream splitOutputStream, Zip4jConfig zip4jConfig) {
        if (this.zipModel.getZipFile().exists()) {
            splitOutputStream.seek(HeaderUtil.getOffsetStartOfCentralDirectory(this.zipModel));
        }
        return new ZipOutputStream(splitOutputStream, this.password, zip4jConfig, this.zipModel);
    }

    void verifyZipParameters(ZipParameters zipParameters) {
        if (zipParameters == null) {
            throw new ZipException("cannot validate zip parameters");
        }
        if (zipParameters.getCompressionMethod() != CompressionMethod.STORE && zipParameters.getCompressionMethod() != CompressionMethod.DEFLATE) {
            throw new ZipException("unsupported compression type");
        }
        if (zipParameters.isEncryptFiles()) {
            if (zipParameters.getEncryptionMethod() == EncryptionMethod.NONE) {
                throw new ZipException("Encryption method has to be set, when encrypt files flag is set");
            }
            if (this.password == null || this.password.length <= 0) {
                throw new ZipException("input password is empty or null");
            }
        } else {
            zipParameters.setEncryptionMethod(EncryptionMethod.NONE);
        }
    }

    void updateLocalFileHeader(FileHeader fileHeader, SplitOutputStream splitOutputStream) {
        this.headerWriter.updateLocalFileHeader(fileHeader, this.getZipModel(), splitOutputStream);
    }

    private ZipParameters cloneAndAdjustZipParameters(ZipParameters zipParameters, File file, ProgressMonitor progressMonitor) {
        ZipParameters zipParameters2 = new ZipParameters(zipParameters);
        zipParameters2.setLastModifiedFileTime(Zip4jUtil.epochToExtendedDosTime(file.lastModified()));
        if (file.isDirectory()) {
            zipParameters2.setEntrySize(0L);
        } else {
            zipParameters2.setEntrySize(file.length());
        }
        zipParameters2.setWriteExtendedLocalFileHeader(false);
        zipParameters2.setLastModifiedFileTime(file.lastModified());
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(zipParameters.getFileNameInZip())) {
            String string = FileUtils.getRelativeFileName(file, zipParameters);
            zipParameters2.setFileNameInZip(string);
        }
        if (file.isDirectory()) {
            zipParameters2.setCompressionMethod(CompressionMethod.STORE);
            zipParameters2.setEncryptionMethod(EncryptionMethod.NONE);
            zipParameters2.setEncryptFiles(false);
        } else {
            if (zipParameters2.isEncryptFiles() && zipParameters2.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD) {
                progressMonitor.setCurrentTask(ProgressMonitor.Task.CALCULATE_CRC);
                zipParameters2.setEntryCRC(CrcUtil.computeFileCrc(file, progressMonitor));
                progressMonitor.setCurrentTask(ProgressMonitor.Task.ADD_ENTRY);
            }
            if (file.length() == 0L) {
                zipParameters2.setCompressionMethod(CompressionMethod.STORE);
            }
        }
        return zipParameters2;
    }

    private List<File> removeFilesIfExists(List<File> list, ZipParameters zipParameters, ProgressMonitor progressMonitor, Zip4jConfig zip4jConfig) {
        ArrayList<File> arrayList = new ArrayList<File>(list);
        if (!this.zipModel.getZipFile().exists()) {
            return arrayList;
        }
        for (File file : list) {
            String string = FileUtils.getRelativeFileName(file, zipParameters);
            FileHeader fileHeader = HeaderUtil.getFileHeader(this.zipModel, string);
            if (fileHeader == null) continue;
            if (zipParameters.isOverrideExistingFilesInZip()) {
                progressMonitor.setCurrentTask(ProgressMonitor.Task.REMOVE_ENTRY);
                this.removeFile(fileHeader, progressMonitor, zip4jConfig);
                this.verifyIfTaskIsCancelled();
                progressMonitor.setCurrentTask(ProgressMonitor.Task.ADD_ENTRY);
                continue;
            }
            arrayList.remove(file);
        }
        return arrayList;
    }

    void removeFile(FileHeader fileHeader, ProgressMonitor progressMonitor, Zip4jConfig zip4jConfig) {
        AsyncZipTask.AsyncTaskParameters asyncTaskParameters = new AsyncZipTask.AsyncTaskParameters(null, false, progressMonitor);
        RemoveFilesFromZipTask removeFilesFromZipTask = new RemoveFilesFromZipTask(this.zipModel, this.headerWriter, asyncTaskParameters);
        RemoveFilesFromZipTask.RemoveFilesFromZipTaskParameters removeFilesFromZipTaskParameters = new RemoveFilesFromZipTask.RemoveFilesFromZipTaskParameters(Collections.singletonList(fileHeader.getFileName()), zip4jConfig);
        removeFilesFromZipTask.execute(removeFilesFromZipTaskParameters);
    }

    private String replaceFileNameInZip(String string, String string2) {
        if (string.contains("/")) {
            return string.substring(0, string.lastIndexOf("/") + 1) + string2;
        }
        return string2;
    }

    private boolean addSymlink(ZipParameters zipParameters) {
        return ZipParameters.SymbolicLinkAction.INCLUDE_LINK_ONLY.equals((Object)zipParameters.getSymbolicLinkAction()) || ZipParameters.SymbolicLinkAction.INCLUDE_LINK_AND_LINKED_FILE.equals((Object)zipParameters.getSymbolicLinkAction());
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.ADD_ENTRY;
    }

    protected ZipModel getZipModel() {
        return this.zipModel;
    }
}

