/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.tasks;

import java.util.concurrent.ExecutorService;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;

public abstract class AsyncZipTask<T> {
    private ProgressMonitor progressMonitor;
    private boolean runInThread;
    private ExecutorService executorService;

    public AsyncZipTask(AsyncTaskParameters asyncTaskParameters) {
        this.progressMonitor = asyncTaskParameters.progressMonitor;
        this.runInThread = asyncTaskParameters.runInThread;
        this.executorService = asyncTaskParameters.executorService;
    }

    public void execute(T t2) {
        this.progressMonitor.fullReset();
        this.progressMonitor.setState(ProgressMonitor.State.BUSY);
        this.progressMonitor.setCurrentTask(this.getTask());
        if (this.runInThread) {
            long l2 = this.calculateTotalWork(t2);
            this.progressMonitor.setTotalWork(l2);
            this.executorService.execute(() -> {
                try {
                    this.performTaskWithErrorHandling(t2, this.progressMonitor);
                }
                catch (ZipException zipException) {
                }
                finally {
                    this.executorService.shutdown();
                }
            });
        } else {
            this.performTaskWithErrorHandling(t2, this.progressMonitor);
        }
    }

    private void performTaskWithErrorHandling(T t2, ProgressMonitor progressMonitor) {
        try {
            this.executeTask(t2, progressMonitor);
            progressMonitor.endProgressMonitor();
        }
        catch (ZipException zipException) {
            progressMonitor.endProgressMonitor(zipException);
            throw zipException;
        }
        catch (Exception exception) {
            progressMonitor.endProgressMonitor(exception);
            throw new ZipException(exception);
        }
    }

    protected void verifyIfTaskIsCancelled() {
        if (!this.progressMonitor.isCancelAllTasks()) {
            return;
        }
        this.progressMonitor.setResult(ProgressMonitor.Result.CANCELLED);
        this.progressMonitor.setState(ProgressMonitor.State.READY);
        throw new ZipException("Task cancelled", ZipException.Type.TASK_CANCELLED_EXCEPTION);
    }

    protected abstract void executeTask(T var1, ProgressMonitor var2);

    protected abstract long calculateTotalWork(T var1);

    protected abstract ProgressMonitor.Task getTask();

    public static class AsyncTaskParameters {
        private ProgressMonitor progressMonitor;
        private boolean runInThread;
        private ExecutorService executorService;

        public AsyncTaskParameters(ExecutorService executorService, boolean bl2, ProgressMonitor progressMonitor) {
            this.executorService = executorService;
            this.runInThread = bl2;
            this.progressMonitor = progressMonitor;
        }
    }
}

