/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.tasks;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderUtil;
import me.forseth11.easybackup.dependencies.zip4j.headers.HeaderWriter;
import me.forseth11.easybackup.dependencies.zip4j.io.outputstream.SplitOutputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.EndOfCentralDirectoryRecord;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.Zip4jConfig;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.RandomAccessFileMode;
import me.forseth11.easybackup.dependencies.zip4j.progress.ProgressMonitor;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractModifyFileTask;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AbstractZipTaskParameters;
import me.forseth11.easybackup.dependencies.zip4j.tasks.AsyncZipTask;

public class RemoveFilesFromZipTask
extends AbstractModifyFileTask<RemoveFilesFromZipTaskParameters> {
    private ZipModel zipModel;
    private HeaderWriter headerWriter;

    public RemoveFilesFromZipTask(ZipModel zipModel, HeaderWriter headerWriter, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel;
        this.headerWriter = headerWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(RemoveFilesFromZipTaskParameters removeFilesFromZipTaskParameters, ProgressMonitor progressMonitor) {
        if (this.zipModel.isSplitArchive()) {
            throw new ZipException("This is a split archive. Zip file format does not allow updating split/spanned files");
        }
        List<String> list = this.filterNonExistingEntries(removeFilesFromZipTaskParameters.filesToRemove);
        if (list.isEmpty()) {
            return;
        }
        File file = this.getTemporaryFile(this.zipModel.getZipFile().getPath());
        boolean bl2 = false;
        try (SplitOutputStream splitOutputStream = new SplitOutputStream(file);
             RandomAccessFile randomAccessFile = new RandomAccessFile(this.zipModel.getZipFile(), RandomAccessFileMode.READ.getValue());){
            long l2 = 0L;
            List<FileHeader> list2 = this.cloneAndSortFileHeadersByOffset(this.zipModel.getCentralDirectory().getFileHeaders());
            for (FileHeader fileHeader : list2) {
                long l3 = this.getOffsetOfNextEntry(list2, fileHeader, this.zipModel) - splitOutputStream.getFilePointer();
                if (this.shouldEntryBeRemoved(fileHeader, list)) {
                    this.updateHeaders(list2, fileHeader, l3);
                    if (!this.zipModel.getCentralDirectory().getFileHeaders().remove(fileHeader)) {
                        throw new ZipException("Could not remove entry from list of central directory headers");
                    }
                    l2 += l3;
                } else {
                    l2 += super.copyFile(randomAccessFile, splitOutputStream, l2, l3, progressMonitor, removeFilesFromZipTaskParameters.zip4jConfig.getBufferSize());
                }
                this.verifyIfTaskIsCancelled();
            }
            this.headerWriter.finalizeZipFile(this.zipModel, splitOutputStream, removeFilesFromZipTaskParameters.zip4jConfig.getCharset());
            bl2 = true;
        }
        finally {
            this.cleanupFile(bl2, this.zipModel.getZipFile(), file);
        }
    }

    @Override
    protected long calculateTotalWork(RemoveFilesFromZipTaskParameters removeFilesFromZipTaskParameters) {
        return this.zipModel.getZipFile().length();
    }

    private List<String> filterNonExistingEntries(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (HeaderUtil.getFileHeader(this.zipModel, string) == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean shouldEntryBeRemoved(FileHeader fileHeader, List<String> list) {
        for (String string : list) {
            if (!fileHeader.getFileName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    private void updateHeaders(List<FileHeader> list, FileHeader fileHeader, long l2) {
        this.updateOffsetsForAllSubsequentFileHeaders(list, this.zipModel, fileHeader, this.negate(l2));
        EndOfCentralDirectoryRecord endOfCentralDirectoryRecord = this.zipModel.getEndOfCentralDirectoryRecord();
        endOfCentralDirectoryRecord.setOffsetOfStartOfCentralDirectory(endOfCentralDirectoryRecord.getOffsetOfStartOfCentralDirectory() - l2);
        endOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectory(endOfCentralDirectoryRecord.getTotalNumberOfEntriesInCentralDirectory() - 1);
        if (endOfCentralDirectoryRecord.getTotalNumberOfEntriesInCentralDirectoryOnThisDisk() > 0) {
            endOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(endOfCentralDirectoryRecord.getTotalNumberOfEntriesInCentralDirectoryOnThisDisk() - 1);
        }
        if (this.zipModel.isZip64Format()) {
            this.zipModel.getZip64EndOfCentralDirectoryRecord().setOffsetStartCentralDirectoryWRTStartDiskNumber(this.zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber() - l2);
            this.zipModel.getZip64EndOfCentralDirectoryRecord().setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(this.zipModel.getZip64EndOfCentralDirectoryRecord().getTotalNumberOfEntriesInCentralDirectory() - 1L);
            this.zipModel.getZip64EndOfCentralDirectoryLocator().setOffsetZip64EndOfCentralDirectoryRecord(this.zipModel.getZip64EndOfCentralDirectoryLocator().getOffsetZip64EndOfCentralDirectoryRecord() - l2);
        }
    }

    private long negate(long l2) {
        if (l2 == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return -l2;
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.REMOVE_ENTRY;
    }

    public static class RemoveFilesFromZipTaskParameters
    extends AbstractZipTaskParameters {
        private List<String> filesToRemove;

        public RemoveFilesFromZipTaskParameters(List<String> list, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.filesToRemove = list;
        }
    }
}

