/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.NumberedSplitInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.SplitInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.ZipInputStream;
import me.forseth11.easybackup.dependencies.zip4j.io.inputstream.ZipStandardSplitInputStream;
import me.forseth11.easybackup.dependencies.zip4j.model.FileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.ZipModel;
import me.forseth11.easybackup.dependencies.zip4j.util.FileUtils;

public class UnzipUtil {
    public static ZipInputStream createZipInputStream(ZipModel zipModel, FileHeader fileHeader, char[] cArray) {
        SplitInputStream splitInputStream = null;
        try {
            splitInputStream = UnzipUtil.createSplitInputStream(zipModel);
            splitInputStream.prepareExtractionForFileHeader(fileHeader);
            ZipInputStream zipInputStream = new ZipInputStream((InputStream)splitInputStream, cArray);
            if (zipInputStream.getNextEntry(fileHeader) == null) {
                throw new ZipException("Could not locate local file header for corresponding file header");
            }
            return zipInputStream;
        }
        catch (IOException iOException) {
            if (splitInputStream != null) {
                splitInputStream.close();
            }
            throw iOException;
        }
    }

    public static void applyFileAttributes(FileHeader fileHeader, File file) {
        try {
            Path path = file.toPath();
            FileUtils.setFileAttributes(path, fileHeader.getExternalFileAttributes());
            FileUtils.setFileLastModifiedTime(path, fileHeader.getLastModifiedTime());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            FileUtils.setFileLastModifiedTimeWithoutNio(file, fileHeader.getLastModifiedTime());
        }
    }

    public static SplitInputStream createSplitInputStream(ZipModel zipModel) {
        File file = zipModel.getZipFile();
        if (file.getName().endsWith(".zip.001")) {
            return new NumberedSplitInputStream(zipModel.getZipFile(), true, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        }
        return new ZipStandardSplitInputStream(zipModel.getZipFile(), zipModel.isSplitArchive(), zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
    }
}

