/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.zip4j.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import me.forseth11.easybackup.dependencies.zip4j.exception.ZipException;
import me.forseth11.easybackup.dependencies.zip4j.model.LocalFileHeader;
import me.forseth11.easybackup.dependencies.zip4j.model.enums.CompressionMethod;

public class Zip4jUtil {
    private static final long DOSTIME_BEFORE_1980 = 0x210000L;
    private static final int MAX_RAW_READ_FULLY_RETRY_ATTEMPTS = 15;

    public static boolean isStringNotNullAndNotEmpty(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static boolean createDirectoryIfNotExists(File file) {
        if (file == null) {
            throw new ZipException("output path is null");
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new ZipException("output directory is not valid");
            }
        } else if (!file.mkdirs()) {
            throw new ZipException("Cannot create output directories");
        }
        return true;
    }

    public static long epochToExtendedDosTime(long l2) {
        if (l2 < 0L) {
            return 0x210000L;
        }
        long l3 = Zip4jUtil.epochToDosTime(l2);
        return l3 != 0x210000L ? l3 + (l2 % 2000L << 32) : 0x210000L;
    }

    private static long epochToDosTime(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        int n2 = calendar.get(1);
        if (n2 < 1980) {
            return 0x210000L;
        }
        return n2 - 1980 << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
    }

    public static long dosToExtendedEpochTme(long l2) {
        long l3 = Zip4jUtil.dosToEpochTime(l2);
        return l3 + (l2 >> 32);
    }

    private static long dosToEpochTime(long l2) {
        int n2 = (int)(l2 << 1 & 0x3EL);
        int n3 = (int)(l2 >> 5 & 0x3FL);
        int n4 = (int)(l2 >> 11 & 0x1FL);
        int n5 = (int)(l2 >> 16 & 0x1FL);
        int n6 = (int)((l2 >> 21 & 0xFL) - 1L);
        int n7 = (int)((l2 >> 25 & 0x7FL) + 1980L);
        Calendar calendar = Calendar.getInstance();
        calendar.set(n7, n6, n5, n4, n3, n2);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public static byte[] convertCharArrayToByteArray(char[] cArray) {
        try {
            ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(cArray));
            byte[] byArray = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray);
            return byArray;
        }
        catch (Exception exception) {
            byte[] byArray = new byte[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                byArray[i2] = (byte)cArray[i2];
            }
            return byArray;
        }
    }

    public static CompressionMethod getCompressionMethod(LocalFileHeader localFileHeader) {
        if (localFileHeader.getCompressionMethod() != CompressionMethod.AES_INTERNAL_ONLY) {
            return localFileHeader.getCompressionMethod();
        }
        if (localFileHeader.getAesExtraDataRecord() == null) {
            throw new RuntimeException("AesExtraDataRecord not present in local header for aes encrypted data");
        }
        return localFileHeader.getAesExtraDataRecord().getCompressionMethod();
    }

    public static int readFully(InputStream inputStream, byte[] byArray) {
        int n2 = inputStream.read(byArray);
        if (n2 != byArray.length && (n2 = Zip4jUtil.readUntilBufferIsFull(inputStream, byArray, n2)) != byArray.length) {
            throw new IOException("Cannot read fully into byte buffer");
        }
        return n2;
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative offset");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (n3 == 0) {
            return 0;
        }
        if (n2 + n3 > byArray.length) {
            throw new IllegalArgumentException("Length greater than buffer size");
        }
        for (n4 = 0; n4 != n3; n4 += n5) {
            n5 = inputStream.read(byArray, n2 + n4, n3 - n4);
            if (n5 != -1) continue;
            if (n4 == 0) {
                return -1;
            }
            return n4;
        }
        return n4;
    }

    private static int readUntilBufferIsFull(InputStream inputStream, byte[] byArray, int n2) {
        int n3 = byArray.length - n2;
        int n4 = 0;
        for (int i2 = 1; n2 < byArray.length && n4 != -1 && i2 < 15; ++i2) {
            n4 = inputStream.read(byArray, n2, n3);
            if (n4 <= 0) continue;
            n2 += n4;
            n3 -= n4;
        }
        return n2;
    }
}

