/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core;

import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;

public final class PluginProps {
    private static final Map<Class<?>, PropsParser<?>> REGISTERED_PARSERS = new HashMap();
    @Nullable
    private Integer resourceId;
    @Nullable
    private Integer bStatsId;
    @Nullable
    private String proxyPackage;
    @Nullable
    private String color;
    @Nullable
    private Boolean supportingExtensions;
    private final Map<String, String> environment = new HashMap<String, String>();
    private boolean usesReflectiveReload = true;

    private PluginProps() {
    }

    public int getResourceId() {
        assert (this.resourceId != null);
        return this.resourceId;
    }

    public void setResourceId(int resourceId) {
        this.resourceId = resourceId;
    }

    public int getBStatsId() {
        assert (this.bStatsId != null);
        return this.bStatsId;
    }

    public void setBStatsId(int bStatsId) {
        this.bStatsId = bStatsId;
    }

    @NotNull
    public String getProxyPackage() {
        assert (this.proxyPackage != null);
        return this.proxyPackage;
    }

    public void setProxyPackage(@NotNull String proxyPackage) {
        this.proxyPackage = proxyPackage;
    }

    @NotNull
    public String getColor() {
        assert (this.color != null);
        return this.color;
    }

    public void setColor(@NotNull String color) {
        this.color = color;
    }

    public boolean isSupportingExtensions() {
        assert (this.supportingExtensions != null);
        return this.supportingExtensions;
    }

    public void setSupportingExtensions(boolean supportingExtensions) {
        this.supportingExtensions = supportingExtensions;
    }

    @Nullable
    public String getEnvironmentVariable(@NotNull String name) {
        return this.environment.get(name);
    }

    public void setEnvironmentVariable(@NotNull String name, @NotNull String value) {
        this.environment.put(name, value);
    }

    public boolean isUsingReflectiveReload() {
        return this.usesReflectiveReload;
    }

    public void setUsesReflectiveReload(boolean usesReflectiveReload) {
        this.usesReflectiveReload = usesReflectiveReload;
    }

    public void validate() {
        if (this.supportingExtensions == null || this.proxyPackage == null || this.color == null || this.bStatsId == null || this.resourceId == null) {
            throw new IllegalStateException("Missing required props!");
        }
    }

    public static <T> PluginProps parse(@NotNull T source, @NotNull Class<? extends T> sourceClass) {
        for (Map.Entry<Class<?>, PropsParser<?>> entry : REGISTERED_PARSERS.entrySet()) {
            Class<?> clazz = entry.getKey();
            if (!clazz.equals(sourceClass)) continue;
            PropsParser<?> parser = entry.getValue();
            return parser.parseFrom(source);
        }
        throw new IllegalArgumentException("No parser exists for class " + sourceClass);
    }

    public static <T> void registerParser(@NotNull Class<T> clazz, @NotNull PropsParser<T> parser) {
        REGISTERED_PARSERS.put(clazz, parser);
    }

    public static boolean hasParserFor(@NotNull Class<?> clazz) {
        for (Class<?> test : REGISTERED_PARSERS.keySet()) {
            if (!test.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Deprecated(since="6.53.0")
    static PluginProps createSimple(int resourceId, int bStatsId, @NotNull String proxyPackage, @NotNull String color, boolean supportsExtensions) {
        PluginProps props = new PluginProps();
        props.setResourceId(resourceId);
        props.setBStatsId(bStatsId);
        props.setProxyPackage(proxyPackage);
        props.setColor(color);
        props.setSupportingExtensions(supportsExtensions);
        return props;
    }

    public static interface PropsParser<T> {
        public PluginProps parseFrom(@NotNull T var1);

        default public PluginProps getBlankProps() {
            return new PluginProps();
        }
    }
}

