/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.command;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.command.NotificationException;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public interface CommandBase {
    @NotNull
    public String getName();

    @NotNull
    public String getPermission();

    public boolean isPlayersOnly();

    @NotNull
    public CommandBase addSubcommand(@NotNull CommandBase var1);

    @NotNull
    public List<CommandBase> getSubcommands();

    @NotNull
    default public CommandBase getWrapped() {
        return this;
    }

    default public void onExecute(@NotNull CommandSender sender, @NotNull List<String> args2) throws NotificationException {
    }

    default public void onExecute(@NotNull Player sender, @NotNull List<String> args2) throws NotificationException {
    }

    @NotNull
    default public List<String> tabComplete(@NotNull CommandSender sender, @NotNull List<String> args2) {
        return new ArrayList<String>();
    }

    @NotNull
    default public List<String> tabComplete(@NotNull Player sender, @NotNull List<String> args2) {
        return new ArrayList<String>();
    }

    default public void notify(@NotNull String key) throws NotificationException {
        throw new NotificationException(key);
    }

    @NotNull
    default public <T> T notifyNull(@Nullable T obj, @NotNull String key) throws NotificationException {
        if (Objects.isNull(obj)) {
            this.notify(key);
        }
        return Objects.requireNonNull(obj);
    }

    @NotNull
    default public <T> T notifyFalse(@NotNull T obj, @NotNull String key, @NotNull Predicate<T> predicate2) throws NotificationException {
        this.notifyFalse(predicate2.test(obj), key);
        return obj;
    }

    default public boolean notifyFalse(boolean condition, @NotNull String key) throws NotificationException {
        if (!condition) {
            this.notify(key);
        }
        return true;
    }

    @NotNull
    default public Player notifyPlayerRequired(@Nullable String playerName, @NotNull String key) throws NotificationException {
        if (playerName == null) {
            this.notify(key);
        }
        if (!1.$assertionsDisabled && playerName == null) {
            throw new AssertionError();
        }
        Player player = Bukkit.getPlayer((String)playerName);
        this.notifyNull(player, key);
        return Objects.requireNonNull(player);
    }

    @NotNull
    default public OfflinePlayer notifyOfflinePlayerRequired(@Nullable String playerName, @NotNull String key) throws NotificationException {
        if (playerName == null) {
            this.notify(key);
        }
        if (!1.$assertionsDisabled && playerName == null) {
            throw new AssertionError();
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        boolean hasPlayedBefore = player.hasPlayedBefore() || player.isOnline();
        this.notifyFalse(!hasPlayedBefore, key);
        return player;
    }

    @NotNull
    default public Player notifyPermissionRequired(@NotNull Player player, @NotNull String permission, @NotNull String key) throws NotificationException {
        return this.notifyFalse(player, key, p -> p.hasPermission(permission));
    }

    public EcoPlugin getPlugin();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

