/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.config;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.config.ConfigType;
import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public final class Configs {
    @NotNull
    public static Config fromBukkit(@Nullable ConfigurationSection config) {
        return config == null ? Configs.empty() : Eco.get().wrapConfigurationSection(config);
    }

    @NotNull
    public static Config fromStream(@Nullable InputStream stream) {
        return stream != null ? Configs.fromBukkit((ConfigurationSection)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream))) : Configs.empty();
    }

    @NotNull
    public static Config fromFile(@Nullable File file) {
        if (file == null) {
            return Configs.empty();
        }
        int lastIndex = file.getName().lastIndexOf(".");
        if (lastIndex < 0) {
            return Configs.empty();
        }
        for (ConfigType type2 : ConfigType.values()) {
            if (!file.getName().substring(lastIndex + 1).equalsIgnoreCase(type2.getExtension())) continue;
            return Configs.fromFile(file, type2);
        }
        return Configs.empty();
    }

    @NotNull
    public static Config fromFile(@Nullable File file, @NotNull ConfigType type2) {
        if (file == null) {
            return Configs.empty();
        }
        try {
            return Eco.get().createConfig(Files.readString(file.toPath()), type2);
        }
        catch (IOException e) {
            return Configs.empty();
        }
    }

    @NotNull
    public static Config fromMap(@NotNull Map<String, Object> values2) {
        return Configs.fromMap(values2, ConfigType.JSON);
    }

    @NotNull
    public static Config fromMap(@NotNull Map<String, Object> values2, @NotNull ConfigType type2) {
        return Eco.get().createConfig(values2, type2);
    }

    @NotNull
    public static Config empty() {
        return Configs.fromMap(new HashMap<String, Object>(), ConfigType.JSON);
    }

    @NotNull
    public static Config empty(@NotNull ConfigType type2) {
        return Configs.fromMap(new HashMap<String, Object>(), type2);
    }

    @NotNull
    public static Config fromString(@NotNull String contents, @NotNull ConfigType type2) {
        return Eco.get().createConfig(contents, type2);
    }

    private Configs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

