/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.config.base;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.config.BaseConfig;
import com.willfp.eco.core.config.ConfigType;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.util.StringUtils;
import java.util.List;

public class LangYml
extends BaseConfig {
    public static final String KEY_MESSAGES = "messages";
    public static final String KEY_PREFIX = "messages.prefix";
    public static final String KEY_NO_PERMISSION = "messages.no-permission";
    public static final String KEY_NOT_PLAYER = "messages.not-player";

    public LangYml(@NotNull EcoPlugin plugin) {
        super("lang", plugin, false, ConfigType.YAML);
    }

    public boolean isValid() {
        for (String key : List.of(KEY_MESSAGES, KEY_PREFIX, KEY_NO_PERMISSION, KEY_NOT_PLAYER)) {
            if (this.has(key)) continue;
            return false;
        }
        return true;
    }

    public String getPrefix() {
        return this.getFormattedString(KEY_PREFIX);
    }

    public String getNoPermission() {
        return this.getPrefix() + this.getFormattedString(KEY_NO_PERMISSION);
    }

    public String getMessage(@NotNull String message) {
        return this.getMessage(message, StringUtils.FormatOption.WITH_PLACEHOLDERS);
    }

    public String getMessage(@NotNull String message, @NotNull StringUtils.FormatOption option) {
        return this.getPrefix() + this.getFormattedString("messages." + message, option);
    }
}

