/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.data.keys;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.data.keys.PersistentDataKeyType;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Objects;
import java.util.Set;
import org.bukkit.NamespacedKey;

public final class PersistentDataKey<T> {
    private final NamespacedKey key;
    private final T defaultValue;
    private final PersistentDataKeyType<T> type;
    private final boolean isLocal;

    public PersistentDataKey(@NotNull NamespacedKey key, @NotNull PersistentDataKeyType<T> type2, @NotNull T defaultValue, boolean isLocal) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.type = type2;
        this.isLocal = isLocal;
        Eco.get().registerPersistentKey(this);
    }

    public PersistentDataKey(@NotNull NamespacedKey key, @NotNull PersistentDataKeyType<T> type2, @NotNull T defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.type = type2;
        this.isLocal = false;
        Eco.get().registerPersistentKey(this);
    }

    public String toString() {
        return "PersistentDataKey{key=" + this.key + ", defaultValue=" + this.defaultValue + ", type=" + this.type + "}";
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public PersistentDataKeyType<T> getType() {
        return this.type;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public static Set<PersistentDataKey<?>> values() {
        return Eco.get().getRegisteredPersistentDataKeys();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PersistentDataKey)) {
            return false;
        }
        PersistentDataKey that = (PersistentDataKey)o;
        return Objects.equals(this.getKey(), that.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }
}

