/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities;

import com.willfp.eco.core.entities.EntitiesLookupHandler;
import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.core.entities.args.EntityArgParseResult;
import com.willfp.eco.core.entities.args.EntityArgParser;
import com.willfp.eco.core.entities.impl.EmptyTestableEntity;
import com.willfp.eco.core.entities.impl.ModifiedTestableEntity;
import com.willfp.eco.core.entities.impl.SimpleTestableEntity;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NamespacedKeyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public final class Entities {
    private static final Map<NamespacedKey, TestableEntity> REGISTRY = new ConcurrentHashMap<NamespacedKey, TestableEntity>();
    private static final List<EntityArgParser> ARG_PARSERS = new ArrayList<EntityArgParser>();
    private static final EntitiesLookupHandler ENTITIES_LOOKUP_HANDLER = new EntitiesLookupHandler(Entities::doParse);

    public static void registerCustomEntity(@NotNull NamespacedKey key, @NotNull TestableEntity item) {
        REGISTRY.put(key, item);
    }

    public static void registerArgParser(@NotNull EntityArgParser parser) {
        ARG_PARSERS.add(parser);
    }

    public static void removeCustomEntity(@NotNull NamespacedKey key) {
        REGISTRY.remove(key);
    }

    @NotNull
    public static TestableEntity lookup(@NotNull String key) {
        return (TestableEntity)ENTITIES_LOOKUP_HANDLER.parseKey(key);
    }

    @NotNull
    private static TestableEntity doParse(@NotNull String[] args2) {
        TestableEntity entity;
        if (args2.length == 0) {
            return new EmptyTestableEntity();
        }
        String[] split = args2[0].toLowerCase().split(":");
        if (split.length == 1) {
            EntityType type2;
            try {
                type2 = EntityType.valueOf((String)args2[0].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return new EmptyTestableEntity();
            }
            entity = new SimpleTestableEntity(type2);
        } else {
            String namespace = split[0];
            String keyID = split[1];
            NamespacedKey namespacedKey = NamespacedKeyUtils.create(namespace, keyID);
            TestableEntity part = REGISTRY.get(namespacedKey);
            if (part == null) {
                return new EmptyTestableEntity();
            }
            entity = part;
        }
        String[] modifierArgs = Arrays.copyOfRange(args2, 1, args2.length);
        ArrayList<EntityArgParseResult> parseResults = new ArrayList<EntityArgParseResult>();
        for (EntityArgParser argParser : ARG_PARSERS) {
            EntityArgParseResult result2 = argParser.parseArguments(modifierArgs);
            if (result2 == null) continue;
            parseResults.add(result2);
        }
        Function<Location, Entity> spawner = entity::spawn;
        if (!parseResults.isEmpty()) {
            entity = new ModifiedTestableEntity(entity, test -> {
                for (EntityArgParseResult parseResult : parseResults) {
                    if (parseResult.test().test((Entity)test)) continue;
                    return false;
                }
                return true;
            }, location -> {
                Entity spawned = (Entity)spawner.apply((Location)location);
                for (EntityArgParseResult parseResult : parseResults) {
                    parseResult.modifier().accept(spawned);
                }
                return spawned;
            });
        }
        return entity;
    }

    @Nullable
    public static TestableEntity getEntity(@Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        TestableEntity customEntity = Entities.getEntity(entity);
        if (customEntity != null) {
            return customEntity;
        }
        for (TestableEntity known : REGISTRY.values()) {
            if (!known.matches(entity)) continue;
            return known;
        }
        if (entity.getType() == EntityType.UNKNOWN) {
            return null;
        }
        return new SimpleTestableEntity(entity.getType());
    }

    public static boolean isCustomEntity(@NotNull Entity entity) {
        for (TestableEntity testable : REGISTRY.values()) {
            if (!testable.matches(entity)) continue;
            return true;
        }
        return false;
    }

    public static Set<TestableEntity> getCustomEntities() {
        return new HashSet<TestableEntity>(REGISTRY.values());
    }

    private Entities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

