/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.ai;

import com.willfp.eco.core.entities.ai.EntityGoal;
import com.willfp.eco.core.entities.ai.GoalFlag;
import com.willfp.eco.core.entities.ai.TargetGoal;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Mob;

public abstract class CustomGoal<T extends Mob>
implements EntityGoal<T>,
TargetGoal<T> {
    private final Set<GoalFlag> flags = EnumSet.noneOf(GoalFlag.class);

    protected CustomGoal() {
    }

    public abstract void initialize(@NotNull T var1);

    public abstract boolean canUse();

    public void tick() {
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public boolean isInterruptable() {
        return true;
    }

    public EnumSet<GoalFlag> getFlags() {
        return EnumSet.copyOf(this.flags);
    }

    public final void setFlags(GoalFlag ... flags) {
        this.setFlags(EnumSet.copyOf(List.of(flags)));
    }

    public void setFlags(@NotNull EnumSet<GoalFlag> flags) {
        this.flags.clear();
        this.flags.addAll(flags);
    }

    @Override
    public T addToEntity(@NotNull T entity, int priority) {
        throw new UnsupportedOperationException("Shorthand syntax is not supported for custom goals by default as they can be both entity and target goals.");
    }
}

