/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.ai;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.entities.ai.EntityGoal;
import com.willfp.eco.core.entities.ai.TargetGoal;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import org.bukkit.entity.Mob;

public interface EntityController<T extends Mob> {
    public EntityController<T> addTargetGoal(int var1, @NotNull TargetGoal<? super T> var2);

    public EntityController<T> clearTargetGoals();

    public EntityController<T> removeTargetGoal(@NotNull TargetGoal<? super T> var1);

    public EntityController<T> addEntityGoal(int var1, @NotNull EntityGoal<? super T> var2);

    public EntityController<T> removeEntityGoal(@NotNull EntityGoal<? super T> var1);

    public EntityController<T> clearEntityGoals();

    default public EntityController<T> clearAllGoals() {
        this.clearTargetGoals();
        return this.clearEntityGoals();
    }

    public T getEntity();

    public static <T extends Mob> EntityController<T> getFor(@NotNull T entity) {
        return Eco.get().createEntityController(entity);
    }
}

