/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.ai.entity;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.entities.Entities;
import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.core.entities.ai.EntityGoal;
import com.willfp.eco.core.serialization.KeyedDeserializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Mob;

public record EntityGoalInteract(@NotNull TestableEntity target, double range, double chance) implements EntityGoal<Mob>
{
    public static final KeyedDeserializer<EntityGoalInteract> DESERIALIZER = new Deserializer();

    private static final class Deserializer
    implements KeyedDeserializer<EntityGoalInteract> {
        private Deserializer() {
        }

        @Override
        @Nullable
        public EntityGoalInteract deserialize(@NotNull Config config) {
            if (!(config.has("target") && config.has("range") && config.has("chance"))) {
                return null;
            }
            return new EntityGoalInteract(Entities.lookup(config.getString("target")), config.getDouble("range"), config.getDouble("chance"));
        }

        @NotNull
        public NamespacedKey getKey() {
            return NamespacedKey.minecraft((String)"interact");
        }
    }
}

