/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.ai.target;

import com.willfp.eco.core.config.interfaces.Config;
import com.willfp.eco.core.entities.Entities;
import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.core.entities.ai.TargetGoal;
import com.willfp.eco.core.serialization.KeyedDeserializer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.function.Predicate;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Raider;

public record TargetGoalNearestHealableRaider(@NotNull TestableEntity target, boolean checkVisibility, @NotNull Predicate<LivingEntity> targetFilter) implements TargetGoal<Raider>
{
    public static final KeyedDeserializer<TargetGoalNearestHealableRaider> DESERIALIZER = new Deserializer();

    public TargetGoalNearestHealableRaider(@NotNull TestableEntity target, boolean checkVisibility) {
        this(target, checkVisibility, it -> true);
    }

    private static final class Deserializer
    implements KeyedDeserializer<TargetGoalNearestHealableRaider> {
        private Deserializer() {
        }

        @Override
        @Nullable
        public TargetGoalNearestHealableRaider deserialize(@NotNull Config config) {
            if (!config.has("target") || !config.has("checkVisibility")) {
                return null;
            }
            if (config.has("targetFilter")) {
                TestableEntity filter2 = Entities.lookup(config.getString("targetFilter"));
                return new TargetGoalNearestHealableRaider(Entities.lookup(config.getString("target")), config.getBool("checkVisibility"), filter2::matches);
            }
            return new TargetGoalNearestHealableRaider(Entities.lookup(config.getString("target")), config.getBool("checkVisibility"));
        }

        @NotNull
        public NamespacedKey getKey() {
            return NamespacedKey.minecraft((String)"nearest_healable_raider");
        }
    }
}

