/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.entities.impl;

import com.willfp.eco.core.entities.TestableEntity;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class ModifiedTestableEntity
implements TestableEntity {
    private final TestableEntity handle;
    private final Predicate<Entity> test;
    private final Function<Location, Entity> provider;

    public ModifiedTestableEntity(@NotNull TestableEntity entity, @NotNull @NotNull Predicate<@NotNull Entity> test, @NotNull Function<Location, Entity> provider) {
        this.handle = entity;
        this.test = test;
        this.provider = provider;
    }

    @Override
    public boolean matches(@Nullable Entity entity) {
        return entity != null && this.handle.matches(entity) && this.test.test(entity);
    }

    @Override
    public Entity spawn(@NotNull Location location) {
        Validate.notNull((Object)location.getWorld());
        return this.provider.apply(location);
    }

    public TestableEntity getHandle() {
        return this.handle;
    }
}

