/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.extensions;

import com.willfp.eco.core.EcoPlugin;
import com.willfp.eco.core.PluginLike;
import com.willfp.eco.core.config.updating.ConfigHandler;
import com.willfp.eco.core.extensions.ExtensionMetadata;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.io.File;
import java.util.logging.Logger;
import org.apache.commons.lang.Validate;

public abstract class Extension
implements PluginLike {
    private final EcoPlugin plugin;
    private ExtensionMetadata metadata = null;

    protected Extension(@NotNull EcoPlugin plugin) {
        this.plugin = plugin;
    }

    public final void enable() {
        Validate.notNull((Object)this.metadata, (String)"Metadata cannot be null!");
        this.onEnable();
    }

    public final void disable() {
        this.onDisable();
    }

    public final void handleAfterLoad() {
        this.onAfterLoad();
    }

    public final void handleReload() {
        this.onReload();
    }

    protected abstract void onEnable();

    protected abstract void onDisable();

    protected void onAfterLoad() {
    }

    protected void onReload() {
    }

    public final void setMetadata(@NotNull ExtensionMetadata metadata2) {
        this.metadata = metadata2;
    }

    public final String getName() {
        Validate.notNull((Object)this.metadata, (String)"Metadata cannot be null!");
        return this.metadata.name();
    }

    public final String getAuthor() {
        Validate.notNull((Object)this.metadata, (String)"Metadata cannot be null!");
        return this.metadata.author();
    }

    public final String getVersion() {
        Validate.notNull((Object)this.metadata, (String)"Metadata cannot be null!");
        return this.metadata.version();
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    @NotNull
    public ConfigHandler getConfigHandler() {
        return this.plugin.getConfigHandler();
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    @Override
    @NotNull
    public File getFile() {
        Validate.notNull((Object)this.metadata, (String)"Metadata cannot be null!");
        return this.metadata.file();
    }

    protected EcoPlugin getPlugin() {
        return this.plugin;
    }
}

