/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.gui.menu;

import com.willfp.eco.core.Eco;
import com.willfp.eco.core.gui.menu.MenuBuilder;
import com.willfp.eco.core.gui.menu.MenuEvent;
import com.willfp.eco.core.gui.menu.MenuType;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public interface Menu {
    public int getRows();

    default public int getColumns() {
        return 9;
    }

    public Slot getSlot(int var1, int var2);

    @Deprecated(since="6.46.0", forRemoval=true)
    default public Slot getSlot(int row2, int column, @NotNull Player player, @NotNull Menu menu) {
        return this.getSlot(row2, column, player);
    }

    default public Slot getSlot(int row2, int column, @NotNull Player player) {
        return this.getSlot(row2, column);
    }

    public String getTitle();

    public Inventory open(@NotNull Player var1);

    public List<ItemStack> getCaptiveItems(@NotNull Player var1);

    @Nullable
    default public ItemStack getCaptiveItem(@NotNull Player player, int row2, int column) {
        return null;
    }

    default public void setState(@NotNull Player player, @NotNull String key, @Nullable Object value) {
    }

    @Deprecated(since="6.44.0", forRemoval=true)
    default public void addState(@NotNull Player player, @NotNull String key, @Nullable Object value) {
        this.setState(player, key, value);
    }

    public void removeState(@NotNull Player var1, @NotNull String var2);

    public void clearState(@NotNull Player var1);

    @Nullable
    public <T> T getState(@NotNull Player var1, @NotNull String var2);

    public Map<String, Object> getState(@NotNull Player var1);

    public void refresh(@NotNull Player var1);

    default public boolean allowsChangingHeldItem() {
        return false;
    }

    default public void callEvent(@NotNull Player player, @NotNull MenuEvent menuEvent) {
    }

    default public int getPage(@NotNull Player player) {
        Integer pageState = (Integer)this.getState(player, "page");
        return Objects.requireNonNullElse(pageState, 1);
    }

    default public int getMaxPage(@NotNull Player player) {
        Integer pageState = (Integer)this.getState(player, "max_page");
        return Objects.requireNonNullElse(pageState, Integer.MAX_VALUE);
    }

    public static MenuBuilder builder(int rows) {
        return Eco.get().createMenuBuilder(rows, MenuType.NORMAL);
    }

    public static MenuBuilder builder(@NotNull MenuType type2) {
        return Eco.get().createMenuBuilder(type2.getDefaultRows(), type2);
    }
}

