/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.core.gui.page;

import com.willfp.eco.core.gui.GUIComponent;
import com.willfp.eco.core.gui.menu.Menu;
import com.willfp.eco.core.gui.page.PageChangeEvent;
import com.willfp.eco.core.gui.slot.Slot;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class PageChanger
implements GUIComponent {
    private final Slot slot;
    private final Direction direction;

    public PageChanger(@NotNull ItemStack itemStack, @NotNull Direction direction) {
        this.direction = direction;
        this.slot = Slot.builder(itemStack).onLeftClick((event, slot, menu) -> {
            Player player = (Player)event.getWhoClicked();
            int page = menu.getPage(player);
            int newPage = Math.max(1, Math.min(page + direction.getChange(), menu.getMaxPage(player)));
            if (newPage == page) {
                return;
            }
            menu.setState(player, "page", newPage);
            menu.callEvent(player, new PageChangeEvent(newPage, page));
        }).build();
    }

    @Override
    public int getRows() {
        return 1;
    }

    @Override
    public int getColumns() {
        return 1;
    }

    @Override
    @Nullable
    public Slot getSlotAt(int row2, int column, @NotNull Player player, @NotNull Menu menu) {
        int page = menu.getPage(player);
        int maxPage = menu.getMaxPage(player);
        if (page <= 1 && this.direction == Direction.BACKWARDS) {
            return null;
        }
        if (page >= maxPage && this.direction == Direction.FORWARDS) {
            return null;
        }
        return this.slot;
    }

    public static enum Direction {
        FORWARDS(1),
        BACKWARDS(-1);

        private final int change;

        private Direction(int change) {
            this.change = change;
        }

        public int getChange() {
            return this.change;
        }
    }
}

